<?php
if (session_status() == PHP_SESSION_NONE) { session_start(); }
if(!isset($_SESSION['status'])){ header("location:login.php"); exit(); }

include 'koneksi.php';
include 'sidebar.php';

date_default_timezone_set('Asia/Jakarta');
$user_id = $_SESSION['id'];
$hari_ini = date('Y-m-d');

// Cek Status Absen Hari Ini
$q_cek = mysqli_query($koneksi, "SELECT * FROM attendance WHERE user_id='$user_id' AND tanggal='$hari_ini'");
$data_absen = mysqli_fetch_assoc($q_cek);

$status_tombol = "belum_absen"; // Default
if($data_absen){
    if($data_absen['jam_pulang'] == NULL){
        $status_tombol = "sudah_masuk"; // Sudah masuk, belum pulang
    } else {
        $status_tombol = "sudah_pulang"; // Sudah selesai hari ini
    }
}
?>

<h3 class="mb-4 fw-bold text-primary"><i class="fas fa-clock me-2"></i> Absensi Saya</h3>

<div class="alert alert-info border-0 shadow-sm d-flex align-items-center">
    <div class="fs-1 me-3"><i class="fas fa-user-circle"></i></div>
    <div>
        <h5 class="mb-0 fw-bold"><?= $_SESSION['nama_lengkap']; ?></h5>
        <small><?= strtoupper($_SESSION['role']); ?></small>
    </div>
    <div class="ms-auto text-end">
        <h4 class="mb-0 fw-bold" id="jam-digital">00:00:00</h4>
        <small><?= date('d F Y'); ?></small>
    </div>
</div>

<div class="card border-0 shadow-sm mb-4 text-center">
    <div class="card-body py-5">
        
        <?php if($status_tombol == "belum_absen"){ ?>
            <h5 class="text-muted mb-4">Anda belum melakukan presensi hari ini.</h5>
            <a href="proses_absen.php?aksi=masuk" class="btn btn-primary btn-lg px-5 py-3 rounded-pill shadow">
                <i class="fas fa-sign-in-alt me-2"></i> ABSEN MASUK
            </a>

        <?php } elseif($status_tombol == "sudah_masuk"){ ?>
            <h5 class="text-success mb-2">Anda sudah Masuk jam <b><?= substr($data_absen['jam_masuk'], 0, 5); ?></b></h5>
            <p class="text-muted mb-4">Klik tombol di bawah jika jam kerja sudah selesai.</p>
            <a href="proses_absen.php?aksi=pulang" class="btn btn-danger btn-lg px-5 py-3 rounded-pill shadow" onclick="return confirm('Yakin ingin absen pulang sekarang?')">
                <i class="fas fa-sign-out-alt me-2"></i> ABSEN PULANG
            </a>

        <?php } else { ?>
            <div class="text-success">
                <i class="fas fa-check-circle fa-5x mb-3"></i>
                <h3>Selesai!</h3>
                <p>Anda sudah menyelesaikan jam kerja hari ini.</p>
                <div class="d-flex justify-content-center gap-3">
                    <span class="badge bg-primary p-2 fs-6">Masuk: <?= substr($data_absen['jam_masuk'], 0, 5); ?></span>
                    <span class="badge bg-danger p-2 fs-6">Pulang: <?= substr($data_absen['jam_pulang'], 0, 5); ?></span>
                </div>
            </div>
        <?php } ?>

    </div>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-header bg-white py-3">
        <h6 class="fw-bold mb-0">Riwayat Kehadiran Bulan Ini</h6>
    </div>
    <div class="table-responsive">
        <table class="table table-hover align-middle mb-0">
            <thead class="bg-light">
                <tr>
                    <th>Tanggal</th>
                    <th>Jam Masuk</th>
                    <th>Jam Pulang</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $bulan_ini = date('Y-m');
                $q_history = mysqli_query($koneksi, "SELECT * FROM attendance WHERE user_id='$user_id' AND tanggal LIKE '$bulan_ini%' ORDER BY tanggal DESC");
                
                while($row = mysqli_fetch_assoc($q_history)){
                ?>
                <tr>
                    <td><?= date('d/m/Y', strtotime($row['tanggal'])); ?></td>
                    <td class="text-primary fw-bold"><?= substr($row['jam_masuk'], 0, 5); ?></td>
                    <td class="text-danger fw-bold"><?= ($row['jam_pulang']) ? substr($row['jam_pulang'], 0, 5) : '-'; ?></td>
                    <td>
                        <?php if($row['status'] == 'telat') { ?>
                            <span class="badge bg-warning text-dark">Telat</span>
                        <?php } else { ?>
                            <span class="badge bg-success">Hadir</span>
                        <?php } ?>
                    </td>
                </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
</div>

<?php include 'footer.php'; ?>

<script>
    // Script Jam Digital Realtime
    setInterval(() => {
        const now = new Date();
        document.getElementById('jam-digital').innerText = now.toLocaleTimeString('id-ID');
    }, 1000);
</script>