<?php
if (session_status() == PHP_SESSION_NONE) { session_start(); }
if(!isset($_SESSION['status'])){ header("location:login.php"); exit(); }

// Hanya Admin yang boleh lihat rekap total
if($_SESSION['role'] != 'admin'){ header("location:absen.php"); exit(); }

include 'koneksi.php';
include 'sidebar.php';

date_default_timezone_set('Asia/Jakarta');

// --- LOGIKA FILTER ---
$tgl_awal  = isset($_GET['tgl_awal']) ? $_GET['tgl_awal'] : date('Y-m-01'); // Awal bulan ini
$tgl_akhir = isset($_GET['tgl_akhir']) ? $_GET['tgl_akhir'] : date('Y-m-d'); // Hari ini

// Query Gabungan (JOIN) users dan attendance
$query_str = "SELECT a.*, u.nama_lengkap, u.role 
              FROM attendance a 
              JOIN users u ON a.user_id = u.id 
              WHERE a.tanggal BETWEEN '$tgl_awal' AND '$tgl_akhir' 
              ORDER BY a.tanggal DESC, a.jam_masuk ASC";

$query = mysqli_query($koneksi, $query_str);

// Hitung Ringkasan Sederhana
$total_hadir = 0;
$total_telat = 0;
?>

<h3 class="mb-4 fw-bold text-primary"><i class="fas fa-clipboard-list me-2"></i> Rekap Absensi Karyawan</h3>

<div class="card border-0 shadow-sm mb-4">
    <div class="card-body py-3">
        <form method="GET" action="" class="d-flex flex-wrap gap-3 align-items-end">
            <div>
                <label class="small text-muted fw-bold">Dari Tanggal</label>
                <input type="date" name="tgl_awal" class="form-control" value="<?= $tgl_awal; ?>">
            </div>
            <div>
                <label class="small text-muted fw-bold">Sampai Tanggal</label>
                <input type="date" name="tgl_akhir" class="form-control" value="<?= $tgl_akhir; ?>">
            </div>
            <button type="submit" class="btn btn-primary"><i class="fas fa-filter me-2"></i> Filter Data</button>
            <a href="admin_absensi.php" class="btn btn-outline-secondary">Reset</a>
            
            <div class="ms-auto">
                <button onclick="window.print()" class="btn btn-success"><i class="fas fa-print me-2"></i> Cetak</button>
            </div>
        </form>
    </div>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="bg-light">
                    <tr>
                        <th class="ps-4">Tanggal</th>
                        <th>Nama Karyawan</th>
                        <th>Jam Masuk</th>
                        <th>Jam Pulang</th>
                        <th>Total Jam</th>
                        <th class="text-center">Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    if(mysqli_num_rows($query) > 0){
                        while($row = mysqli_fetch_assoc($query)){
                            // Hitung Statistik
                            if($row['status'] == 'telat') $total_telat++;
                            else $total_hadir++;

                            // Hitung Durasi Kerja
                            $durasi = "-";
                            if($row['jam_pulang'] != NULL){
                                $masuk  = new DateTime($row['jam_masuk']);
                                $pulang = new DateTime($row['jam_pulang']);
                                $diff   = $masuk->diff($pulang);
                                $durasi = $diff->h . " Jam " . $diff->i . " Menit";
                            }
                    ?>
                    <tr>
                        <td class="ps-4"><?= date('d/m/Y', strtotime($row['tanggal'])); ?></td>
                        <td>
                            <div class="fw-bold"><?= $row['nama_lengkap']; ?></div>
                            <small class="text-muted text-uppercase" style="font-size: 11px;"><?= $row['role']; ?></small>
                        </td>
                        <td class="text-primary fw-bold"><?= substr($row['jam_masuk'], 0, 5); ?></td>
                        <td class="text-danger fw-bold"><?= ($row['jam_pulang']) ? substr($row['jam_pulang'], 0, 5) : '<span class="badge bg-light text-muted">Belum</span>'; ?></td>
                        <td><?= $durasi; ?></td>
                        <td class="text-center">
                            <?php if($row['status'] == 'telat') { ?>
                                <span class="badge bg-warning text-dark">TELAT</span>
                            <?php } elseif($row['status'] == 'sakit') { ?>
                                <span class="badge bg-info">SAKIT</span>
                            <?php } elseif($row['status'] == 'izin') { ?>
                                <span class="badge bg-secondary">IZIN</span>
                            <?php } else { ?>
                                <span class="badge bg-success">ON TIME</span>
                            <?php } ?>
                        </td>
                    </tr>
                    <?php 
                        }
                    } else {
                        echo '<tr><td colspan="6" class="text-center py-5 text-muted">Tidak ada data absensi pada periode ini.</td></tr>';
                    } 
                    ?>
                </tbody>
            </table>
        </div>
    </div>
    <div class="card-footer bg-white d-flex justify-content-end gap-4 py-3">
        <span class="text-success fw-bold"><i class="fas fa-check-circle me-1"></i> Tepat Waktu: <?= $total_hadir; ?></span>
        <span class="text-warning fw-bold"><i class="fas fa-exclamation-triangle me-1"></i> Telat: <?= $total_telat; ?></span>
    </div>
</div>

<?php include 'footer.php'; ?>