<?php
session_start();
if(!isset($_SESSION['status']) || $_SESSION['status'] != "sudah_login"){ header("location:login.php"); exit(); }
include 'sidebar.php'; 
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h3 class="fw-bold text-dark mb-0">📦 Stok Bahan Baku</h3>
        <span class="text-muted small">Kelola inventory gudang dapur</span>
    </div>
</div>

<div class="row">
    <div class="col-md-4 mb-4">
        <div class="card border-0 shadow-sm sticky-top" style="top:80px; z-index:1;">
            <div class="card-header bg-white py-3">
                <h6 class="fw-bold text-primary mb-0" id="form-title"><i class="fas fa-plus-circle me-2"></i> Tambah Bahan</h6>
            </div>
            <div class="card-body">
                <input type="hidden" id="bahan-id">
                
                <div class="mb-3">
                    <label class="form-label small fw-bold text-secondary">NAMA BAHAN</label>
                    <input type="text" id="nama" class="form-control" placeholder="Contoh: Beras Premium">
                </div>

                <div class="row">
                    <div class="col-6 mb-3">
                        <label class="form-label small fw-bold text-secondary">SATUAN</label>
                        <select id="satuan" class="form-select">
                            <option value="Kg">Kg</option>
                            <option value="Liter">Liter</option>
                            <option value="Gram">Gram</option>
                            <option value="Pcs">Pcs</option>
                            <option value="Butir">Butir</option>
                            <option value="Ikat">Ikat</option>
                            <option value="Botol">Botol</option>
                        </select>
                    </div>
                    <div class="col-6 mb-3">
                        <label class="form-label small fw-bold text-secondary">STOK SAAT INI</label>
                        <input type="number" id="stok" class="form-control" placeholder="0">
                    </div>
                </div>

                <div class="d-grid">
                    <button onclick="simpanBahan()" class="btn btn-primary">
                        <i class="fas fa-save me-2"></i> SIMPAN
                    </button>
                    <button id="btn-batal" onclick="resetForm()" class="btn btn-light text-muted mt-2" style="display:none;">
                        Batal
                    </button>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-8">
        <div class="card border-0 shadow-sm">
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="bg-light">
                            <tr>
                                <th class="ps-4 py-3 text-secondary small text-uppercase">Nama Bahan</th>
                                <th class="py-3 text-secondary small text-uppercase">Stok Gudang</th>
                                <th class="py-3 text-secondary small text-uppercase text-end pe-4">Aksi</th>
                            </tr>
                        </thead>
                        <tbody id="tabel-bahan">
                            <tr><td colspan="3" class="text-center py-4 text-muted">Memuat data...</td></tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>

<script>
    const API_BASE = window.location.protocol + '//' + window.location.hostname + '/api_kasir/';
    
    loadBahan();

    function loadBahan(){
        fetch(API_BASE + 'get_bahan.php').then(res => res.json()).then(data => {
            let html = '';
            if(data.length === 0) { html = '<tr><td colspan="3" class="text-center py-4 text-muted">Belum ada bahan baku</td></tr>'; }
            else {
                data.forEach(item => {
                    // Warna stok: Merah jika < 10
                    let badgeColor = item.stok < 10 ? 'bg-danger' : 'bg-success';
                    
                    html += `<tr>
                        <td class="ps-4 fw-bold text-dark">${item.nama_bahan}</td>
                        <td>
                            <span class="badge ${badgeColor} bg-opacity-75" style="font-size:14px;">
                                ${item.stok} ${item.satuan}
                            </span>
                        </td>
                        <td class="text-end pe-4">
                            <button onclick="editBahan('${item.id}', '${item.nama_bahan}', '${item.satuan}', '${item.stok}')" class="btn btn-sm btn-warning text-white me-1"><i class="fas fa-edit"></i></button>
                            <button onclick="hapusBahan('${item.id}', '${item.nama_bahan}')" class="btn btn-sm btn-danger"><i class="fas fa-trash"></i></button>
                        </td>
                    </tr>`;
                });
            }
            document.getElementById('tabel-bahan').innerHTML = html;
        });
    }

    function simpanBahan(){
        const id = document.getElementById('bahan-id').value;
        const nama = document.getElementById('nama').value;
        const satuan = document.getElementById('satuan').value;
        const stok = document.getElementById('stok').value;

        if(nama === "" || stok === "") { alert("Lengkapi data!"); return; }

        let aksi = (id === "") ? 'tambah' : 'edit';
        fetch(API_BASE + 'kelola_bahan.php', {
            method: 'POST',
            body: JSON.stringify({ aksi, id, nama, satuan, stok })
        })
        .then(res => res.json()).then(hasil => {
            alert(hasil.pesan);
            resetForm();
            loadBahan();
        });
    }

    function editBahan(id, nama, satuan, stok){
        document.getElementById('form-title').innerHTML = '<i class="fas fa-edit me-2"></i> Edit Bahan';
        document.getElementById('bahan-id').value = id;
        document.getElementById('nama').value = nama;
        document.getElementById('satuan').value = satuan;
        document.getElementById('stok').value = stok;
        document.getElementById('btn-batal').style.display = 'block';
    }

    function hapusBahan(id, nama){
        if(confirm("Hapus bahan " + nama + "?")) {
            fetch(API_BASE + 'kelola_bahan.php', { method: 'POST', body: JSON.stringify({ aksi: 'hapus', id }) })
            .then(res => res.json()).then(hasil => { loadBahan(); });
        }
    }

    function resetForm(){
        document.getElementById('form-title').innerHTML = '<i class="fas fa-plus-circle me-2"></i> Tambah Bahan';
        document.getElementById('bahan-id').value = "";
        document.getElementById('nama').value = "";
        document.getElementById('stok').value = "";
        document.getElementById('satuan').value = "Kg";
        document.getElementById('btn-batal').style.display = 'none';
    }
</script>