<?php
if (session_status() == PHP_SESSION_NONE) { session_start(); }
if(!isset($_SESSION['status']) || $_SESSION['role'] != 'admin'){ header("location:login.php"); exit(); }

include 'koneksi.php';
include 'sidebar.php'; 

date_default_timezone_set('Asia/Jakarta');

// --- 1. LOGIKA MODE & TANGGAL ---
$mode = isset($_GET['mode']) ? $_GET['mode'] : 'bulanan'; // Default Bulanan

if($mode == 'bulanan'){
    // MODE BULANAN
    $input_value = isset($_GET['periode']) ? $_GET['periode'] : date('Y-m'); // Format: 2025-01
    
    $tgl_awal  = date('Y-m-01', strtotime($input_value));
    $tgl_akhir = date('Y-m-t', strtotime($input_value)); // t = tanggal terakhir bulan itu
    $periode_kode = $input_value;
    $label_periode = date('F Y', strtotime($input_value));

} else {
    // MODE MINGGUAN
    $input_value = isset($_GET['periode']) ? $_GET['periode'] : date('Y-\WW'); // Format: 2025-W01
    
    $dto = new DateTime();
    $thn = substr($input_value, 0, 4);
    $mgg = substr($input_value, 6, 2);
    $dto->setISODate($thn, $mgg); 

    $tgl_senin  = $dto->format('Y-m-d');
    $dto->modify('+6 days');
    $tgl_minggu = $dto->format('Y-m-d');

    $tgl_awal  = $tgl_senin;
    $tgl_akhir = $tgl_minggu;
    $periode_kode = $input_value;
    $label_periode = date('d M', strtotime($tgl_senin)) . " s/d " . date('d M Y', strtotime($tgl_minggu));
}
?>

<h3 class="mb-4 fw-bold text-primary"><i class="fas fa-money-check-alt me-2"></i> Penggajian Karyawan</h3>

<div class="card border-0 shadow-sm mb-4">
    <div class="card-body py-3">
        <form method="GET" action="" class="row g-3 align-items-center">
            
            <div class="col-auto">
                <label class="fw-bold">Mode Gaji:</label>
                <select name="mode" class="form-select bg-light fw-bold text-primary" onchange="this.form.submit()">
                    <option value="bulanan" <?= ($mode == 'bulanan') ? 'selected' : ''; ?>>BULANAN</option>
                    <option value="mingguan" <?= ($mode == 'mingguan') ? 'selected' : ''; ?>>MINGGUAN</option>
                </select>
            </div>

            <div class="col-auto">
                <label class="fw-bold">Pilih Periode:</label>
                <?php if($mode == 'bulanan') { ?>
                    <input type="month" name="periode" class="form-control" value="<?= $input_value; ?>" onchange="this.form.submit()">
                <?php } else { ?>
                    <input type="week" name="periode" class="form-control" value="<?= $input_value; ?>" onchange="this.form.submit()">
                <?php } ?>
            </div>

            <div class="col-auto pt-4">
                <span class="text-muted small border-start ps-3">
                    <i class="fas fa-calendar-check me-1"></i> Rentang: <b><?= $tgl_awal; ?></b> s/d <b><?= $tgl_akhir; ?></b>
                </span>
            </div>

        </form>
    </div>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="bg-light">
                    <tr>
                        <th>Nama Karyawan</th>
                        <th class="text-center">Kehadiran</th>
                        <th>Perhitungan</th>
                        <th class="text-end">Total Gaji</th>
                        <th class="text-center">Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $q_user = mysqli_query($koneksi, "SELECT * FROM users WHERE is_active=1 ORDER BY role ASC");
                    
                    while($karyawan = mysqli_fetch_assoc($q_user)){
                        $uid = $karyawan['id'];
                        $gaji_pokok = $karyawan['gaji_pokok'];

                        // 2. HITUNG HADIR (Range Dinamis)
                        $q_absen = mysqli_query($koneksi, "SELECT COUNT(*) as jumlah FROM attendance 
                                                           WHERE user_id='$uid' 
                                                           AND tanggal BETWEEN '$tgl_awal' AND '$tgl_akhir' 
                                                           AND (status='hadir' OR status='telat')");
                        $d_absen = mysqli_fetch_assoc($q_absen);
                        $total_hadir = $d_absen['jumlah'];

                        $total_terima = $total_hadir * $gaji_pokok;

                        // 3. CEK PEMBAYARAN (Cek Jenis Periode Juga)
                        $q_payroll = mysqli_query($koneksi, "SELECT * FROM payroll 
                                                             WHERE user_id='$uid' 
                                                             AND periode_kode='$periode_kode' 
                                                             AND jenis_periode='$mode'");
                        $sudah_bayar = mysqli_fetch_assoc($q_payroll);
                    ?>
                    <tr>
                        <td>
                            <div class="fw-bold"><?= $karyawan['nama_lengkap']; ?></div>
                            <small class="text-muted text-uppercase"><?= $karyawan['role']; ?></small>
                        </td>
                        <td class="text-center">
                            <span class="badge bg-info text-dark fs-6"><?= $total_hadir; ?> Hari</span>
                        </td>
                        <td>
                            <small class="d-block text-muted">Harian: Rp <?= number_format($gaji_pokok,0,',','.'); ?></small>
                            <small class="d-block text-muted">Hadir: <?= $total_hadir; ?> x</small>
                        </td>
                        <td class="text-end fw-bold text-success fs-5">
                            Rp <?= number_format($total_terima, 0, ',', '.'); ?>
                        </td>
                        <td class="text-center">
    <?php if($sudah_bayar) { ?>
        <a href="cetak_slip.php?id=<?= $sudah_bayar['id']; ?>" target="_blank" class="btn btn-sm btn-outline-success fw-bold">
            <i class="fas fa-print me-1"></i> CETAK SLIP
        </a>
        <br>
        <small class="text-muted" style="font-size: 10px;">
            Lunas: <?= date('d/m H:i', strtotime($sudah_bayar['tanggal_bayar'])); ?>
        </small>
    <?php } else { ?>
        
        <?php if($total_terima > 0){ ?>
            <button class="btn btn-primary btn-sm" onclick="bayarGaji(
                '<?= $karyawan['id']; ?>',
                '<?= $karyawan['nama_lengkap']; ?>',
                '<?= $total_hadir; ?>',
                '<?= $gaji_pokok; ?>',
                '<?= $total_terima; ?>'
            )">
                <i class="fas fa-hand-holding-usd me-1"></i> Bayar
            </button>
        <?php } else { ?>
            <span class="text-muted small">-</span>
        <?php } ?>

    <?php } ?>
</td>

                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<div class="modal fade" id="modalBayar" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title fw-bold">Konfirmasi Pembayaran</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="proses_gaji.php" method="POST">
                <div class="modal-body">
                    <input type="hidden" name="user_id" id="bayar_uid">
                    
                    <input type="hidden" name="mode" value="<?= $mode; ?>">
                    <input type="hidden" name="periode_kode" value="<?= $periode_kode; ?>">
                    <input type="hidden" name="tgl_awal" value="<?= $tgl_awal; ?>">
                    <input type="hidden" name="tgl_akhir" value="<?= $tgl_akhir; ?>">

                    <div class="alert alert-warning py-2 small">
                        Jenis: <b><?= strtoupper($mode); ?></b> <br>
                        Periode: <?= $label_periode; ?>
                    </div>

                    <div class="mb-2">
                        <label class="fw-bold">Nama Karyawan</label>
                        <input type="text" id="bayar_nama" class="form-control-plaintext fw-bold" readonly>
                    </div>
                    <div class="row">
                        <div class="col-6 mb-2">
                            <label class="fw-bold">Jml Hadir</label>
                            <input type="text" name="jumlah_hadir" id="bayar_hadir" class="form-control" readonly>
                        </div>
                        <div class="col-6 mb-2">
                            <label class="fw-bold">Gaji Harian</label>
                            <input type="text" name="gaji_harian" id="bayar_harian" class="form-control" readonly>
                        </div>
                    </div>
                    <div class="mb-2">
                        <label class="fw-bold text-success">Total Bayar (Rp)</label>
                        <input type="number" name="total_gaji" id="bayar_total" class="form-control fw-bold text-success fs-4" readonly>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Konfirmasi Bayar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>

<script>
    const modalBayar = new bootstrap.Modal(document.getElementById('modalBayar'));

    function bayarGaji(uid, nama, hadir, harian, total){
        document.getElementById('bayar_uid').value = uid;
        document.getElementById('bayar_nama').value = nama;
        document.getElementById('bayar_hadir').value = hadir;
        document.getElementById('bayar_harian').value = harian;
        document.getElementById('bayar_total').value = total;
        modalBayar.show();
    }
</script>