<?php
session_start();
if(!isset($_SESSION['status']) || $_SESSION['status'] != "sudah_login"){ header("location:login.php"); exit(); }
include 'sidebar.php'; 
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h3 class="fw-bold text-dark mb-0">📂 Atur Posisi Kategori</h3>
</div>

<div class="row">
    <div class="col-md-4 mb-4">
        <div class="card border-0 shadow-sm sticky-top" style="top:80px; z-index:1;">
            <div class="card-header bg-white py-3">
                <h6 class="fw-bold text-primary mb-0" id="form-title"><i class="fas fa-plus-circle me-2"></i> Tambah Kategori</h6>
            </div>
            <div class="card-body">
                <input type="hidden" id="cat-id">
                <div class="mb-3">
                    <label class="form-label small fw-bold text-secondary">NAMA KATEGORI</label>
                    <input type="text" id="nama" class="form-control" placeholder="Misal: Best Seller">
                </div>
                <div class="d-grid">
                    <button onclick="simpanKategori()" class="btn btn-primary"><i class="fas fa-save me-2"></i> SIMPAN</button>
                    <button id="btn-batal" onclick="resetForm()" class="btn btn-light text-muted mt-2" style="display:none;">Batal</button>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-8">
        <div class="card border-0 shadow-sm">
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="bg-light">
                            <tr>
                                <th class="ps-4 py-3 text-secondary small text-uppercase">Urutan</th>
                                <th class="py-3 text-secondary small text-uppercase">Nama Kategori</th>
                                <th class="py-3 text-secondary small text-uppercase text-end pe-4">Aksi</th>
                            </tr>
                        </thead>
                        <tbody id="tabel-kategori">
                            <tr><td colspan="3" class="text-center py-4">Memuat data...</td></tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="text-muted small mt-2">
            * Klik panah ⬆️ ⬇️ untuk mengubah urutan tampilan di HP Pelanggan.
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>

<script>
    const API_BASE = window.location.protocol + '//' + window.location.hostname + '/api_kasir/';
    
    loadKategori();

    function loadKategori(){
        fetch(API_BASE + 'get_kategori.php').then(res => res.json()).then(data => {
            let html = '';
            if(data.length === 0) { html = '<tr><td colspan="3" class="text-center py-4 text-muted">Belum ada kategori</td></tr>'; }
            else {
                data.forEach((item, index) => {
                    html += `<tr>
                        <td class="ps-4" style="width: 100px;">
                            <div class="btn-group" role="group">
                                <button onclick="geser('${item.id}', 'naik')" class="btn btn-sm btn-outline-secondary" title="Naik" ${index===0 ? 'disabled':''}><i class="fas fa-arrow-up"></i></button>
                                <button onclick="geser('${item.id}', 'turun')" class="btn btn-sm btn-outline-secondary" title="Turun" ${index===data.length-1 ? 'disabled':''}><i class="fas fa-arrow-down"></i></button>
                            </div>
                        </td>
                        
                        <td class="fw-bold text-dark">${item.nama_kategori}</td>
                        
                        <td class="text-end pe-4">
                            <button onclick="editKat('${item.id}', '${item.nama_kategori}')" class="btn btn-sm btn-warning text-white me-1"><i class="fas fa-edit"></i></button>
                            <button onclick="hapusKat('${item.id}', '${item.nama_kategori}')" class="btn btn-sm btn-danger"><i class="fas fa-trash"></i></button>
                        </td>
                    </tr>`;
                });
            }
            document.getElementById('tabel-kategori').innerHTML = html;
        });
    }

    function geser(id, arah){
        fetch(API_BASE + 'kelola_kategori.php', {
            method: 'POST',
            body: JSON.stringify({ aksi: 'geser', id: id, arah: arah })
        })
        .then(res => res.json())
        .then(hasil => {
            // Langsung reload tabel biar kerasa gesernya
            loadKategori();
        });
    }

    function simpanKategori(){
        const id = document.getElementById('cat-id').value;
        const nama = document.getElementById('nama').value;
        if(nama === "") { alert("Nama Kosong!"); return; }
        let aksi = (id === "") ? 'tambah' : 'edit';
        fetch(API_BASE + 'kelola_kategori.php', { method: 'POST', body: JSON.stringify({ aksi, id, nama }) })
        .then(res => res.json()).then(hasil => { alert(hasil.pesan); resetForm(); loadKategori(); });
    }

    function editKat(id, nama){
        document.getElementById('form-title').innerHTML = '<i class="fas fa-edit me-2"></i> Edit Kategori';
        document.getElementById('cat-id').value = id;
        document.getElementById('nama').value = nama;
        document.getElementById('btn-batal').style.display = 'block';
    }

    function hapusKat(id, nama){
        if(confirm("Hapus " + nama + "?")) {
            fetch(API_BASE + 'kelola_kategori.php', { method: 'POST', body: JSON.stringify({ aksi: 'hapus', id }) })
            .then(res => res.json()).then(hasil => { loadKategori(); });
        }
    }

    function resetForm(){
        document.getElementById('form-title').innerHTML = '<i class="fas fa-plus-circle me-2"></i> Tambah Kategori';
        document.getElementById('cat-id').value = "";
        document.getElementById('nama').value = "";
        document.getElementById('btn-batal').style.display = 'none';
    }
</script>