<?php
session_start();
// Cek Login
if(!isset($_SESSION['status']) || $_SESSION['status'] != "sudah_login"){ header("location:login.php"); exit(); }
// Panggil Sidebar
include 'sidebar.php'; 
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h3 class="fw-bold text-dark mb-0">🍽️ Kelola Menu & Stok</h3>
        <span class="text-muted small">Atur harga, foto, dan stok menu siap jual</span>
    </div>
</div>

<div class="row">
    <div class="col-md-4 mb-4">
        <div class="card border-0 shadow-sm sticky-top" style="top: 80px; z-index: 1;"> <div class="card-header bg-white py-3 border-bottom">
                <h6 class="fw-bold text-primary mb-0" id="form-title">
                    <i class="fas fa-plus-circle me-2"></i> Tambah Menu
                </h6>
            </div>
            <div class="card-body p-4">
                <input type="hidden" id="menu-id">

                <div class="mb-3">
                    <label class="form-label small fw-bold text-secondary">NAMA MENU</label>
                    <input type="text" id="nama" class="form-control" placeholder="Contoh: Nasi Goreng">
                </div>

                <div class="row">
                    <div class="col-6 mb-3">
                        <label class="form-label small fw-bold text-secondary">HARGA (RP)</label>
                        <input type="number" id="harga" class="form-control" placeholder="15000">
                    </div>
                    <div class="col-6 mb-3">
                        <label class="form-label small fw-bold text-secondary">STOK</label>
                        <input type="number" id="stok" class="form-control" placeholder="100">
                    </div>
                </div>

                <div class="mb-3">
                    <label class="form-label small fw-bold text-secondary">KATEGORI</label>
                    <select id="kategori" class="form-select">
                        <option value="">-- Memuat... --</option>
                    </select>
                </div>

                <div class="mb-4">
                    <label class="form-label small fw-bold text-secondary">FOTO PRODUK</label>
                    <input type="file" id="foto" class="form-control" accept="image/*">
                    <div class="form-text small">*Kosongkan jika tidak ubah foto</div>
                </div>

                <div class="d-grid gap-2">
                    <button onclick="simpanMenu()" class="btn btn-primary fw-bold shadow-sm">
                        <i class="fas fa-save me-2"></i> SIMPAN
                    </button>
                    <button id="btn-batal" onclick="resetForm()" class="btn btn-light text-muted" style="display:none;">
                        Batal Edit
                    </button>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-8">
        <div class="card border-0 shadow-sm">
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="bg-light">
                            <tr>
                                <th class="ps-4 py-3 text-secondary small text-uppercase">Produk</th>
                                <th class="py-3 text-secondary small text-uppercase">Harga</th>
                                <th class="py-3 text-secondary small text-uppercase">Stok</th>
                                <th class="py-3 text-secondary small text-uppercase text-end pe-4">Aksi</th>
                            </tr>
                        </thead>
                        <tbody id="tabel-menu">
                            <tr><td colspan="4" class="text-center py-5 text-muted">Sedang memuat data...</td></tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>

<script>
    // Setting API & Path Gambar
    const API_BASE = window.location.protocol + '//' + window.location.hostname + '/api_kasir/';
    const IMG_PATH = API_BASE + 'images/'; 

    // Jalankan saat load
    loadKategoriOptions();
    loadMenu();

    // 1. Ambil Data Kategori untuk Dropdown
    function loadKategoriOptions(){
        fetch(API_BASE + 'get_kategori.php').then(res => res.json()).then(data => {
            let html = '<option value="">-- Pilih Kategori --</option>';
            if(data.length > 0){
                data.forEach(item => { 
                    html += `<option value="${item.id}">${item.nama_kategori}</option>`; 
                });
            }
            document.getElementById('kategori').innerHTML = html;
        });
    }

    // 2. Ambil Data Menu untuk Tabel
    function loadMenu() {
        fetch(API_BASE + 'get_menu.php').then(res => res.json()).then(data => {
            let html = '';
            if(data.length === 0){ 
                html = '<tr><td colspan="4" class="text-center py-5 text-muted">Belum ada menu. Silakan tambah.</td></tr>'; 
            } else {
                data.forEach(item => {
                    // Logic Nama Kategori
                    let namaKat = item.nama_kategori ? item.nama_kategori : '-';
                    
                    // Logic Foto
                    let fotoSrc = (item.foto && item.foto !== 'no-image.jpg') ? IMG_PATH + item.foto : 'https://via.placeholder.com/60?text=No+Img';
                    
                    // Logic Warna Stok (Merah jika < 5)
                    let stokBadge = item.stok < 5 
                        ? `<span class="badge bg-danger bg-opacity-10 text-danger">${item.stok} (Tipis)</span>` 
                        : `<span class="fw-bold text-dark">${item.stok}</span>`;

                    html += `<tr>
                        <td class="ps-4 py-3">
                            <div class="d-flex align-items-center">
                                <img src="${fotoSrc}" style="width:50px; height:50px; object-fit:cover; border-radius:10px; margin-right:15px; border:1px solid #eee;">
                                <div>
                                    <div class="fw-bold text-dark">${item.nama_produk}</div>
                                    <span class="badge bg-light text-secondary border fw-normal">${namaKat}</span>
                                </div>
                            </div>
                        </td>
                        <td class="fw-bold text-success">Rp ${parseInt(item.harga).toLocaleString('id-ID')}</td>
                        <td>${stokBadge}</td>
                        <td class="text-end pe-4">
                            
                            <a href="admin_resep.php?id=${item.id}&nama=${encodeURIComponent(item.nama_produk)}" 
                               class="btn btn-sm btn-info text-white me-1 shadow-sm" title="Atur Resep Bahan">
                               <i class="fas fa-blender"></i>
                            </a>

                            <button onclick="isiFormEdit('${item.id}', '${item.nama_produk}', '${item.harga}', '${item.category_id}', '${item.stok}')" 
                                class="btn btn-sm btn-warning text-white me-1 shadow-sm" title="Edit Menu">
                                <i class="fas fa-edit"></i>
                            </button>
                            
                            <button onclick="hapusMenu('${item.id}', '${item.nama_produk}')" 
                                class="btn btn-sm btn-danger shadow-sm" title="Hapus Menu">
                                <i class="fas fa-trash"></i>
                            </button>
                        </td>
                    </tr>`;
                });
            }
            document.getElementById('tabel-menu').innerHTML = html;
        });
    }

    // 3. Simpan Menu (Tambah/Edit) dengan FormData
    function simpanMenu() {
        const id = document.getElementById('menu-id').value;
        const nama = document.getElementById('nama').value;
        const harga = document.getElementById('harga').value;
        const stok = document.getElementById('stok').value;
        const kategori = document.getElementById('kategori').value;
        const fileInput = document.getElementById('foto');

        // Validasi
        if(nama == "" || harga == "" || stok == "" || kategori == "") { 
            alert("Nama, Harga, Stok, dan Kategori wajib diisi!"); 
            return; 
        }

        const formData = new FormData();
        formData.append('aksi', (id === "") ? 'tambah' : 'edit');
        formData.append('id', id);
        formData.append('nama', nama);
        formData.append('harga', harga);
        formData.append('stok', stok);
        formData.append('kategori', kategori);
        
        // Kirim foto jika ada yang dipilih
        if(fileInput.files.length > 0){
            formData.append('foto', fileInput.files[0]);
        }

        fetch(API_BASE + 'kelola_menu.php', { method: 'POST', body: formData })
        .then(res => res.json()).then(hasil => {
            alert(hasil.pesan);
            if(hasil.status === 'sukses'){ 
                resetForm(); 
                loadMenu(); 
            }
        })
        .catch(err => alert("Terjadi kesalahan sistem."));
    }

    // 4. Hapus Menu
    function hapusMenu(id, nama) {
        if(confirm("Yakin ingin menghapus menu " + nama + "?")) {
            const formData = new FormData();
            formData.append('aksi', 'hapus');
            formData.append('id', id);
            fetch(API_BASE + 'kelola_menu.php', { method: 'POST', body: formData })
            .then(res => res.json()).then(hasil => { 
                alert(hasil.pesan);
                loadMenu(); 
            });
        }
    }

    // 5. Isi Form Edit
    function isiFormEdit(id, nama, harga, k_id, stok) {
        document.getElementById('form-title').innerHTML = '<i class="fas fa-edit me-2"></i> Edit Menu';
        document.getElementById('menu-id').value = id;
        document.getElementById('nama').value = nama;
        document.getElementById('harga').value = harga;
        document.getElementById('stok').value = stok;
        document.getElementById('kategori').value = k_id;
        document.getElementById('foto').value = ""; // Reset input foto
        
        document.getElementById('btn-batal').style.display = 'inline-block';
        window.scrollTo(0,0);
    }

    // 6. Reset Form
    function resetForm() {
        document.getElementById('form-title').innerHTML = '<i class="fas fa-plus-circle me-2"></i> Tambah Menu';
        document.getElementById('menu-id').value = "";
        document.getElementById('nama').value = "";
        document.getElementById('harga').value = "";
        document.getElementById('stok').value = "";
        document.getElementById('kategori').value = "";
        document.getElementById('foto').value = "";
        
        document.getElementById('btn-batal').style.display = 'none';
    }
</script>