<?php
if (session_status() == PHP_SESSION_NONE) { session_start(); }
if(!isset($_SESSION['status'])){ header("location:login.php"); exit(); }

include 'koneksi.php';
include 'sidebar.php'; 

// 1. SET TIMEZONE
date_default_timezone_set('Asia/Jakarta');
$hari_ini  = date('Y-m-d');
$bulan_ini = date('Y-m');

// --- LOGIKA HITUNG RINGKASAN ---

// 1. Hari Ini
$qDay = mysqli_query($koneksi, "SELECT SUM(nominal) as total FROM expenses WHERE DATE(tanggal) = '$hari_ini'");
$dDay = mysqli_fetch_assoc($qDay);
$totalHariIni = $dDay['total'] ?? 0;

// 2. Minggu Ini
$monday = date('Y-m-d', strtotime('monday this week'));
$sunday = date('Y-m-d', strtotime('sunday this week'));
$qWeek = mysqli_query($koneksi, "SELECT SUM(nominal) as total FROM expenses WHERE DATE(tanggal) BETWEEN '$monday' AND '$sunday'");
$dWeek = mysqli_fetch_assoc($qWeek);
$totalMingguIni = $dWeek['total'] ?? 0;

// 3. Bulan Ini
$qMonth = mysqli_query($koneksi, "SELECT SUM(nominal) as total FROM expenses WHERE DATE_FORMAT(tanggal, '%Y-%m') = '$bulan_ini'");
$dMonth = mysqli_fetch_assoc($qMonth);
$totalBulanIni = $dMonth['total'] ?? 0;

// --- FILTER TANGGAL ---
$tgl_awal  = isset($_GET['tgl_awal']) ? $_GET['tgl_awal'] : date('Y-m-01');
$tgl_akhir = isset($_GET['tgl_akhir']) ? $_GET['tgl_akhir'] : date('Y-m-d');
$filter_mode = isset($_GET['filter']);

$where = "";
if($filter_mode){
    $where = "WHERE DATE(tanggal) BETWEEN '$tgl_awal' AND '$tgl_akhir'";
}
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h3 class="fw-bold text-dark mb-0">💸 Data Pengeluaran</h3>
        <span class="text-muted small">Catat dan pantau biaya operasional restoran</span>
    </div>
    <button type="button" class="btn btn-primary fw-bold shadow-sm" onclick="tambahData()">
        <i class="fas fa-plus me-2"></i> Catat Baru
    </button>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-4">
        <div class="card border-0 shadow-sm h-100 p-3">
            <div class="d-flex align-items-center">
                <div class="icon-box bg-primary bg-opacity-10 text-primary rounded-circle p-3 me-3">
                    <i class="fas fa-calendar-day fa-lg"></i>
                </div>
                <div>
                    <small class="text-uppercase text-muted fw-bold" style="font-size:11px;">Hari Ini</small>
                    <h4 class="mb-0 fw-bold text-dark">Rp <?= number_format($totalHariIni, 0, ',', '.'); ?></h4>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card border-0 shadow-sm h-100 p-3">
            <div class="d-flex align-items-center">
                <div class="icon-box bg-success bg-opacity-10 text-success rounded-circle p-3 me-3">
                    <i class="fas fa-calendar-week fa-lg"></i>
                </div>
                <div>
                    <small class="text-uppercase text-muted fw-bold" style="font-size:11px;">Minggu Ini</small>
                    <h4 class="mb-0 fw-bold text-dark">Rp <?= number_format($totalMingguIni, 0, ',', '.'); ?></h4>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card border-0 shadow-sm h-100 p-3">
            <div class="d-flex align-items-center">
                <div class="icon-box bg-warning bg-opacity-10 text-warning rounded-circle p-3 me-3">
                    <i class="fas fa-calendar-alt fa-lg"></i>
                </div>
                <div>
                    <small class="text-uppercase text-muted fw-bold" style="font-size:11px;">Bulan Ini</small>
                    <h4 class="mb-0 fw-bold text-dark">Rp <?= number_format($totalBulanIni, 0, ',', '.'); ?></h4>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card border-0 shadow-sm mb-4">
    <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
        <h6 class="fw-bold text-primary mb-0"><i class="fas fa-list me-2"></i> Riwayat Pengeluaran</h6>
        
        <form method="GET" action="" class="d-flex gap-2 align-items-center">
            <div class="input-group input-group-sm">
                <span class="input-group-text bg-light border-0"><i class="fas fa-calendar"></i></span>
                <input type="date" name="tgl_awal" class="form-control border-light bg-light" value="<?= $tgl_awal; ?>" required>
            </div>
            <span class="text-muted">-</span>
            <div class="input-group input-group-sm">
                <input type="date" name="tgl_akhir" class="form-control border-light bg-light" value="<?= $tgl_akhir; ?>" required>
            </div>
            <button type="submit" name="filter" value="true" class="btn btn-sm btn-light border fw-bold text-muted">
                Filter
            </button>
            <?php if($filter_mode){ ?>
                <a href="admin_pengeluaran.php" class="btn btn-sm btn-link text-danger text-decoration-none">Reset</a>
            <?php } ?>
        </form>
    </div>

    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="bg-light text-secondary">
                    <tr>
                        <th class="ps-4 text-uppercase small fw-bold border-0">Tanggal</th>
                        <th class="text-uppercase small fw-bold border-0">Deskripsi</th>
                        <th class="text-uppercase small fw-bold border-0">Sumber Dana</th> <th class="text-uppercase small fw-bold border-0">Kategori</th>
                        <th class="text-end text-uppercase small fw-bold border-0 pe-4">Nominal</th>
                        <th class="text-center text-uppercase small fw-bold border-0">Aksi</th>
                    </tr>
                </thead>
                <tbody class="border-top-0">
                    <?php
                    $total_filter = 0;
                    $query = mysqli_query($koneksi, "SELECT * FROM expenses $where ORDER BY tanggal DESC");
                    
                    if(mysqli_num_rows($query) > 0){
                        while($row = mysqli_fetch_assoc($query)){
                            $total_filter += $row['nominal'];
                            
                            // Badge Warna Kategori
                            $badge_class = 'bg-secondary';
                            if($row['kategori'] == 'Bahan Baku') $badge_class = 'bg-info text-dark';
                            elseif($row['kategori'] == 'Operasional') $badge_class = 'bg-warning text-dark';
                            elseif($row['kategori'] == 'Gaji') $badge_class = 'bg-danger';

                            // Cek Sumber Dana (untuk fallback jika data lama kosong)
                            $sumber = isset($row['sumber_dana']) ? $row['sumber_dana'] : 'laci';
                            $badge_sumber = ($sumber == 'bank') ? 'bg-primary' : 'bg-success';
                    ?>
                    <tr>
                        <td class="ps-4">
                            <div class="fw-bold text-dark"><?= date('d M Y', strtotime($row['tanggal'])); ?></div>
                            <small class="text-muted"><?= date('H:i', strtotime($row['tanggal'])); ?></small>
                        </td>
                        <td class="fw-bold text-dark"><?= $row['deskripsi']; ?></td>
                        <td>
                            <span class="badge rounded-pill <?= $badge_sumber; ?> bg-opacity-75" style="font-weight:500; font-size:11px; text-transform:uppercase;">
                                <?= $sumber; ?>
                            </span>
                        </td>
                        <td>
                            <span class="badge rounded-pill <?= $badge_class; ?> bg-opacity-75" style="font-weight:500; font-size:12px;">
                                <?= $row['kategori']; ?>
                            </span>
                        </td>
                        <td class="text-end pe-4 fw-bold text-danger">
                            Rp <?= number_format($row['nominal'], 0, ',', '.'); ?>
                        </td>
                        <td class="text-center">
                            <div class="btn-group">
                                <button class="btn btn-sm btn-light text-primary" 
                                    onclick="editData(
                                        '<?= $row['id']; ?>',
                                        '<?= htmlspecialchars($row['deskripsi']); ?>',
                                        '<?= $row['nominal']; ?>',
                                        '<?= $row['kategori']; ?>',
                                        '<?= $sumber; ?>',
                                        '<?= date('Y-m-d\TH:i', strtotime($row['tanggal'])); ?>'
                                    )" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <a href="kelola_pengeluaran.php?aksi=hapus&id=<?= $row['id']; ?>" class="btn btn-sm btn-light text-danger" onclick="return confirm('Yakin hapus data ini?')" title="Hapus">
                                    <i class="fas fa-trash"></i>
                                </a>
                            </div>
                        </td>
                    </tr>
                    <?php } 
                    } else {
                        echo '<tr><td colspan="6" class="text-center text-muted py-5"><i class="fas fa-inbox fa-2x mb-2 opacity-50"></i><br>Tidak ada data pengeluaran.</td></tr>';
                    }
                    ?>
                </tbody>
                <tfoot class="bg-light">
                    <tr>
                        <td colspan="4" class="text-end fw-bold text-secondary text-uppercase small ps-4 pt-3">Total Periode Ini:</td>
                        <td class="text-end fw-bold text-dark fs-6 pe-4 pt-3">Rp <?= number_format($total_filter, 0, ',', '.'); ?></td>
                        <td></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>

<div class="d-flex justify-content-end mb-5">
    <a href="export_pengeluaran.php?tgl_awal=<?= $tgl_awal ?>&tgl_akhir=<?= $tgl_akhir ?>" target="_blank" class="btn btn-success fw-bold shadow-sm">
        <i class="fas fa-file-excel me-2"></i> Download Laporan Excel
    </a>
</div>

<div class="modal fade" id="modalPengeluaran" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content border-0 shadow">
            <div class="modal-header bg-white border-bottom-0">
                <h5 class="modal-title fw-bold text-dark" id="modalTitle">Tambah Pengeluaran</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="kelola_pengeluaran.php" method="POST">
                <div class="modal-body">
                    <input type="hidden" name="id" id="id_pengeluaran">
                    <input type="hidden" name="aksi" id="form_aksi" value="tambah">

                    <div class="mb-3">
                        <label class="form-label small fw-bold text-secondary">TANGGAL & WAKTU</label>
                        <input type="datetime-local" name="tanggal" id="tanggal" class="form-control bg-light border-0" required>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label small fw-bold text-secondary">DESKRIPSI</label>
                        <input type="text" name="deskripsi" id="deskripsi" class="form-control bg-light border-0" placeholder="Contoh: Beli Gas 3kg" required>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label small fw-bold text-secondary">KATEGORI</label>
                            <select name="kategori" id="kategori" class="form-select bg-light border-0" required>
                                <option value="Bahan Baku">Bahan Baku</option>
                                <option value="Operasional">Operasional</option>
                                <option value="Gaji">Gaji Karyawan</option>
                                <option value="Lainnya">Lainnya</option>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label small fw-bold text-secondary">SUMBER DANA</label>
                            <select name="sumber_dana" id="sumber_dana" class="form-select bg-light border-0" required>
                                <option value="laci">Kas Laci (Tunai)</option>
                                <option value="bank">Rekening Bank</option>
                            </select>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label small fw-bold text-secondary">NOMINAL (RP)</label>
                        <input type="number" name="nominal" id="nominal" class="form-control bg-light border-0 fw-bold text-dark" required>
                    </div>
                </div>
                <div class="modal-footer border-top-0 pt-0">
                    <button type="button" class="btn btn-light text-muted fw-bold" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary fw-bold px-4">Simpan Data</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>

<script>
    const modal = new bootstrap.Modal(document.getElementById('modalPengeluaran'));

    function tambahData(){
        document.getElementById('modalTitle').innerText = "Catat Pengeluaran Baru";
        document.getElementById('form_aksi').value = "tambah";
        document.getElementById('id_pengeluaran').value = "";
        document.getElementById('deskripsi').value = "";
        document.getElementById('nominal').value = "";
        
        // Reset pilihan ke default
        document.getElementById('sumber_dana').value = "laci"; 
        
        const now = new Date();
        now.setMinutes(now.getMinutes() - now.getTimezoneOffset());
        document.getElementById('tanggal').value = now.toISOString().slice(0,16);

        modal.show();
    }

    function editData(id, deskripsi, nominal, kategori, sumber, tanggal){
        document.getElementById('modalTitle').innerText = "Edit Pengeluaran";
        document.getElementById('form_aksi').value = "edit";
        document.getElementById('id_pengeluaran').value = id;
        
        document.getElementById('deskripsi').value = deskripsi;
        document.getElementById('nominal').value = nominal;
        document.getElementById('kategori').value = kategori;
        document.getElementById('sumber_dana').value = sumber; // Load data sumber dana
        document.getElementById('tanggal').value = tanggal;

        modal.show();
    }
</script>