<?php
session_start();
if(!isset($_SESSION['status']) || $_SESSION['status'] != "sudah_login"){ header("location:login.php"); exit(); }
include 'sidebar.php'; 

// Ambil ID Produk dari URL (misal: admin_resep.php?id=5&nama=Nasi%20Goreng)
$id_produk = isset($_GET['id']) ? $_GET['id'] : '';
$nama_produk = isset($_GET['nama']) ? $_GET['nama'] : 'Menu';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h3 class="fw-bold text-dark mb-0">👨‍🍳 Racik Resep</h3>
        <span class="text-muted">Menu: <b class="text-primary"><?php echo $nama_produk; ?></b></span>
    </div>
    <a href="admin_menu.php" class="btn btn-outline-secondary btn-sm"><i class="fas fa-arrow-left"></i> Kembali</a>
</div>

<div class="row">
    <div class="col-md-4 mb-4">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-white py-3">
                <h6 class="fw-bold text-primary mb-0"><i class="fas fa-plus me-2"></i> Tambah Bahan Baku</h6>
            </div>
            <div class="card-body">
                <input type="hidden" id="prod-id" value="<?php echo $id_produk; ?>">
                
                <div class="mb-3">
                    <label class="form-label small fw-bold text-secondary">PILIH BAHAN</label>
                    <select id="pilih-bahan" class="form-select">
                        <option value="">Memuat bahan...</option>
                    </select>
                </div>

                <div class="mb-3">
                    <label class="form-label small fw-bold text-secondary">JUMLAH PAKAI</label>
                    <div class="input-group">
                        <input type="number" id="jumlah" class="form-control" placeholder="Contoh: 200">
                        <span class="input-group-text" id="label-satuan">-</span>
                    </div>
                    <small class="text-muted" style="font-size:11px">Berapa banyak bahan ini dipakai untuk 1 porsi menu ini?</small>
                </div>

                <button onclick="tambahBahan()" class="btn btn-success w-100 fw-bold">TAMBAHKAN KE RESEP</button>
            </div>
        </div>
    </div>

    <div class="col-md-8">
        <div class="card border-0 shadow-sm">
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="bg-light">
                            <tr>
                                <th class="ps-4 py-3">Nama Bahan</th>
                                <th class="py-3">Jumlah Pakai</th>
                                <th class="py-3 text-end pe-4">Aksi</th>
                            </tr>
                        </thead>
                        <tbody id="tabel-resep">
                            <tr><td colspan="3" class="text-center py-4">Memuat data...</td></tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

</div></div> 

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    document.getElementById("sidebarToggle").onclick = function() { document.body.classList.toggle("sb-sidenav-toggled"); };
    
    const API_BASE = window.location.protocol + '//' + window.location.hostname + '/api_kasir/';
    const PRODUCT_ID = document.getElementById('prod-id').value;

    // INIT
    loadDropdownBahan();
    loadResep();

    // 1. ISI DROPDOWN BAHAN BAKU
    function loadDropdownBahan(){
        fetch(API_BASE + 'get_bahan.php').then(res => res.json()).then(data => {
            let html = '<option value="">-- Pilih Bahan --</option>';
            data.forEach(item => {
                html += `<option value="${item.id}" data-satuan="${item.satuan}">${item.nama_bahan} (Stok: ${item.stok} ${item.satuan})</option>`;
            });
            document.getElementById('pilih-bahan').innerHTML = html;
        });
    }

    // Ubah label satuan saat dropdown berubah
    document.getElementById('pilih-bahan').addEventListener('change', function(){
        const satuan = this.options[this.selectedIndex].getAttribute('data-satuan') || '-';
        document.getElementById('label-satuan').innerText = satuan;
    });

    // 2. LOAD TABEL RESEP
    function loadResep(){
        fetch(API_BASE + 'kelola_resep.php?id_produk=' + PRODUCT_ID)
        .then(res => res.json())
        .then(data => {
            let html = '';
            if(data.length === 0){ html = '<tr><td colspan="3" class="text-center py-4 text-muted">Belum ada resep.</td></tr>'; }
            else {
                data.forEach(item => {
                    html += `<tr>
                        <td class="ps-4 fw-bold text-dark">${item.nama_bahan}</td>
                        <td class="fw-bold text-primary">${item.jumlah_pakai} ${item.satuan}</td>
                        <td class="text-end pe-4">
                            <button onclick="hapusBahan('${item.id}')" class="btn btn-sm btn-danger"><i class="fas fa-trash"></i></button>
                        </td>
                    </tr>`;
                });
            }
            document.getElementById('tabel-resep').innerHTML = html;
        });
    }

    // 3. TAMBAH BAHAN
    function tambahBahan(){
        const mat_id = document.getElementById('pilih-bahan').value;
        const jumlah = document.getElementById('jumlah').value;
        
        if(mat_id == "" || jumlah == ""){ alert("Pilih bahan dan isi jumlah!"); return; }

        fetch(API_BASE + 'kelola_resep.php', {
            method: 'POST',
            body: JSON.stringify({ aksi: 'tambah', product_id: PRODUCT_ID, material_id: mat_id, jumlah: jumlah })
        }).then(res => res.json()).then(() => {
            loadResep();
            document.getElementById('jumlah').value = "";
        });
    }

    // 4. HAPUS BAHAN
    function hapusBahan(id){
        if(confirm("Hapus bahan ini dari resep?")){
            fetch(API_BASE + 'kelola_resep.php', {
                method: 'POST',
                body: JSON.stringify({ aksi: 'hapus', id: id })
            }).then(res => res.json()).then(() => { loadResep(); });
        }
    }
</script>
</body>
</html>