<?php
session_start();
if(!isset($_SESSION['status']) || $_SESSION['status'] != "sudah_login"){ header("location:login.php"); exit(); }

include 'koneksi.php';
include 'sidebar.php';

// --- 1. KUNCI WAKTU ---
date_default_timezone_set('Asia/Jakarta');
$hari_ini       = date('Y-m-d');
$waktu_sekarang = date('Y-m-d H:i:s'); 

// --- 2. PROSES SIMPAN (SETOR & TARIK) ---

// A. PROSES SETOR (Laci -> Bank)
if(isset($_POST['simpan_setoran'])){
    $nominal = $_POST['nominal'];
    $ket     = $_POST['keterangan'];
    $user_id = $_SESSION['user_id'];

    $q = "INSERT INTO cash_flows (tanggal, jenis, nominal, keterangan, user_id) 
          VALUES ('$waktu_sekarang', 'setor_bank', '$nominal', '$ket', '$user_id')";
    
    if(mysqli_query($koneksi, $q)){
        echo "<script>alert('Berhasil Setor! Uang pindah ke Bank.'); window.location='admin_setor.php';</script>";
    }
}

// B. PROSES TARIK (Bank -> Laci)
if(isset($_POST['simpan_tarikan'])){
    $nominal = $_POST['nominal'];
    $ket     = $_POST['keterangan'];
    $user_id = $_SESSION['user_id'];

    $q = "INSERT INTO cash_flows (tanggal, jenis, nominal, keterangan, user_id) 
          VALUES ('$waktu_sekarang', 'tarik_bank', '$nominal', '$ket', '$user_id')";
    
    if(mysqli_query($koneksi, $q)){
        echo "<script>alert('Berhasil Tarik! Uang masuk ke Laci Kasir.'); window.location='admin_setor.php';</script>";
    }
}

// --- 3. LOGIKA HITUNG SALDO ---

// A. HITUNG LACI (HARI INI)
// (+) Jualan Tunai
$q_masuk = mysqli_query($koneksi, "SELECT SUM(total_bayar) as total FROM transactions WHERE DATE(tanggal_buat) = '$hari_ini' AND status='paid' AND (metode_bayar = 'cash' OR metode_bayar IS NULL)"); 
$d_masuk = mysqli_fetch_assoc($q_masuk);
$tunai_masuk = $d_masuk['total'] ?? 0;

// (+) Tarik Tunai dari Bank (Uang Masuk ke Laci) - HARI INI
$q_tarik_laci = mysqli_query($koneksi, "SELECT SUM(nominal) as total FROM cash_flows WHERE jenis='tarik_bank' AND DATE(tanggal) = '$hari_ini'");
$d_tarik_laci = mysqli_fetch_assoc($q_tarik_laci);
$tunai_ditarik = $d_tarik_laci['total'] ?? 0;

// (-) Bayar Pengeluaran
$q_keluar = mysqli_query($koneksi, "SELECT SUM(nominal) as total FROM expenses WHERE DATE(tanggal) = '$hari_ini' AND sumber_dana = 'laci'");
$d_keluar = mysqli_fetch_assoc($q_keluar);
$tunai_keluar = $d_keluar['total'] ?? 0;

// (-) Setor ke Bank
$q_setor = mysqli_query($koneksi, "SELECT SUM(nominal) as total FROM cash_flows WHERE jenis='setor_bank' AND DATE(tanggal) = '$hari_ini'");
$d_setor = mysqli_fetch_assoc($q_setor);
$tunai_disetor = $d_setor['total'] ?? 0;

// RUMUS LACI: (Masuk + Tarikan) - (Keluar + Setoran)
$saldo_laci_saat_ini = ($tunai_masuk + $tunai_ditarik) - ($tunai_keluar + $tunai_disetor);


// B. HITUNG BANK (AKUMULASI TOTAL)
// (+) Jualan Non-Tunai
$q_bank_jual = mysqli_query($koneksi, "SELECT SUM(total_bayar) as total FROM transactions WHERE status='paid' AND metode_bayar != 'cash' AND metode_bayar IS NOT NULL");
$d_bank_jual = mysqli_fetch_assoc($q_bank_jual);
$bank_dari_jualan = $d_bank_jual['total'] ?? 0;

// (+) Setoran Masuk
$q_bank_setor = mysqli_query($koneksi, "SELECT SUM(nominal) as total FROM cash_flows WHERE jenis='setor_bank'");
$d_bank_setor = mysqli_fetch_assoc($q_bank_setor);
$bank_dari_setoran = $d_bank_setor['total'] ?? 0;

// (-) Pengeluaran via Bank
$q_bank_keluar = mysqli_query($koneksi, "SELECT SUM(nominal) as total FROM expenses WHERE sumber_dana = 'bank'");
$d_bank_keluar = mysqli_fetch_assoc($q_bank_keluar);
$bank_keluar = $d_bank_keluar['total'] ?? 0;

// (-) Penarikan Tunai
$q_bank_tarik = mysqli_query($koneksi, "SELECT SUM(nominal) as total FROM cash_flows WHERE jenis='tarik_bank'");
$d_bank_tarik = mysqli_fetch_assoc($q_bank_tarik);
$bank_tarik_total = $d_bank_tarik['total'] ?? 0;

// RUMUS BANK
$saldo_bank_total = ($bank_dari_jualan + $bank_dari_setoran) - ($bank_keluar + $bank_tarik_total);


// C. HITUNG TOTAL ASET
$total_keseluruhan = $saldo_laci_saat_ini + $saldo_bank_total;
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h3 class="fw-bold text-dark mb-0">🏦 Manajemen Keuangan</h3>
        <span class="text-muted">Pantau arus kas Laci, Bank, dan Total Aset</span>
    </div>
</div>

<div class="row mb-4 g-3">
    
    <div class="col-md-4">
        <div class="card bg-success text-white shadow-sm h-100 border-0">
            <div class="card-body p-3">
                <div class="d-flex justify-content-between align-items-center mb-2">
                    <h6 class="text-white-50 text-uppercase fw-bold mb-0" style="font-size: 0.8rem;">Uang Fisik (Laci)</h6>
                    <i class="fas fa-cash-register text-white-50"></i>
                </div>
                <h3 class="fw-bold mb-0">Rp <?= number_format($saldo_laci_saat_ini, 0, ',', '.'); ?></h3>
                <div class="mt-2 pt-2 border-top border-white border-opacity-25 small">
                    <div class="d-flex justify-content-between">
                        <span>Penjualan Tunai:</span> <span>+<?= number_format($tunai_masuk); ?></span>
                    </div>
                    <div class="d-flex justify-content-between text-warning fw-bold">
                        <span>Tarik dr Bank:</span> <span>+<?= number_format($tunai_ditarik); ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card bg-primary text-white shadow-sm h-100 border-0">
            <div class="card-body p-3">
                <div class="d-flex justify-content-between align-items-center mb-2">
                    <h6 class="text-white-50 text-uppercase fw-bold mb-0" style="font-size: 0.8rem;">Saldo Rekening Bank</h6>
                    <i class="fas fa-university text-white-50"></i>
                </div>
                <h3 class="fw-bold mb-0">Rp <?= number_format($saldo_bank_total, 0, ',', '.'); ?></h3>
                <div class="mt-2 pt-2 border-top border-white border-opacity-25 small">
                     <div class="d-flex justify-content-between">
                        <span>Total Setor:</span> <span>+<?= number_format($bank_dari_setoran); ?></span>
                    </div>
                    <div class="d-flex justify-content-between text-warning fw-bold">
                        <span>Total Tarik:</span> <span>-<?= number_format($bank_tarik_total); ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card bg-dark text-white shadow-sm h-100 border-0" style="background: linear-gradient(45deg, #1e293b, #334155);">
            <div class="card-body p-3">
                <div class="d-flex justify-content-between align-items-center mb-2">
                    <h6 class="text-warning text-uppercase fw-bold mb-0" style="font-size: 0.8rem;">Total Aset (Cash + Bank)</h6>
                    <i class="fas fa-coins text-warning"></i>
                </div>
                <h3 class="fw-bold mb-0 text-warning">Rp <?= number_format($total_keseluruhan, 0, ',', '.'); ?></h3>
                <div class="mt-2 pt-2 border-top border-white border-opacity-25 small text-white-50">
                    Gabungan uang tunai di tangan dan saldo di bank saat ini.
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-white py-0 pt-3 border-bottom-0">
                <ul class="nav nav-tabs card-header-tabs" id="myTab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active fw-bold text-success" id="setor-tab" data-bs-toggle="tab" data-bs-target="#setor" type="button" role="tab"><i class="fas fa-arrow-up me-2"></i>SETOR (Laci ➔ Bank)</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link fw-bold text-warning" id="tarik-tab" data-bs-toggle="tab" data-bs-target="#tarik" type="button" role="tab"><i class="fas fa-arrow-down me-2"></i>TARIK (Bank ➔ Laci)</button>
                    </li>
                </ul>
            </div>
            
            <div class="card-body">
                <div class="tab-content" id="myTabContent">
                    
                    <div class="tab-pane fade show active" id="setor" role="tabpanel">
                        <form method="POST">
                            <div class="alert alert-success small border-0 bg-opacity-10 text-success p-2 mb-3">
                                <i class="fas fa-info-circle me-1"></i> Memindahkan uang dari <b>Laci</b> ke <b>Bank</b>.
                            </div>
                            <div class="mb-3">
                                <label class="form-label fw-bold small text-muted">NOMINAL SETOR (RP)</label>
                                <input type="number" name="nominal" class="form-control fw-bold" required max="<?= ($saldo_laci_saat_ini > 0 ? $saldo_laci_saat_ini : 0); ?>">
                                <div class="form-text text-danger">*Maksimal Rp <?= number_format($saldo_laci_saat_ini, 0, ',', '.'); ?></div>
                            </div>
                            <div class="mb-3">
                                <label class="form-label fw-bold small text-muted">KETERANGAN</label>
                                <textarea name="keterangan" class="form-control" rows="2" placeholder="Ket: Setor Pendapatan Pagi"></textarea>
                            </div>
                            <button type="submit" name="simpan_setoran" class="btn btn-success w-100 fw-bold" onclick="return confirm('Yakin Setor? Saldo Laci akan berkurang.')">
                                <i class="fas fa-save me-2"></i> SIMPAN SETORAN
                            </button>
                        </form>
                    </div>

                    <div class="tab-pane fade" id="tarik" role="tabpanel">
                        <form method="POST">
                            <div class="alert alert-warning small border-0 bg-opacity-10 text-dark p-2 mb-3">
                                <i class="fas fa-info-circle me-1"></i> Mengambil uang di <b>Bank</b> untuk dimasukkan ke <b>Laci</b> (Kembalian/Kas).
                            </div>
                            <div class="mb-3">
                                <label class="form-label fw-bold small text-muted">NOMINAL TARIK (RP)</label>
                                <input type="number" name="nominal" class="form-control fw-bold border-warning" required max="<?= ($saldo_bank_total > 0 ? $saldo_bank_total : 0); ?>">
                                <div class="form-text text-danger">*Maksimal Saldo Bank: Rp <?= number_format($saldo_bank_total, 0, ',', '.'); ?></div>
                            </div>
                            <div class="mb-3">
                                <label class="form-label fw-bold small text-muted">KETERANGAN</label>
                                <textarea name="keterangan" class="form-control border-warning" rows="2" placeholder="Ket: Ambil uang untuk kembalian"></textarea>
                            </div>
                            <button type="submit" name="simpan_tarikan" class="btn btn-warning w-100 fw-bold" onclick="return confirm('Yakin Tarik? Saldo Bank berkurang, Laci bertambah.')">
                                <i class="fas fa-save me-2"></i> SIMPAN TARIKAN
                            </button>
                        </form>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <div class="col-md-6">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-white py-3">
                <h6 class="fw-bold mb-0 text-dark"><i class="fas fa-history me-2"></i> Mutasi Hari Ini</h6>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="bg-light text-secondary">
                            <tr>
                                <th class="ps-3">Jam</th>
                                <th>Tipe</th>
                                <th>Ket</th>
                                <th class="text-end pe-3">Jumlah</th>
                            </tr>
                        </thead>
                        <tbody style="font-size: 0.9rem;">
                            <?php
                            // Ambil Setor & Tarik hari ini
                            $q_hist = mysqli_query($koneksi, "SELECT * FROM cash_flows WHERE (jenis='setor_bank' OR jenis='tarik_bank') AND DATE(tanggal)='$hari_ini' ORDER BY id DESC");
                            if(mysqli_num_rows($q_hist) > 0){
                                while($row = mysqli_fetch_assoc($q_hist)){
                                    if($row['jenis'] == 'setor_bank'){
                                        $badge = '<span class="badge bg-success">SETOR</span>';
                                        $warna = 'text-success';
                                        $icon  = '<i class="fas fa-arrow-up"></i>';
                                    } else {
                                        $badge = '<span class="badge bg-warning text-dark">TARIK</span>';
                                        $warna = 'text-danger'; // Merah karena mengurangi bank, atau bisa text-dark
                                        $icon  = '<i class="fas fa-arrow-down"></i>';
                                    }
                                    echo "<tr>
                                            <td class='ps-3'>".date('H:i', strtotime($row['tanggal']))."</td>
                                            <td>$badge</td>
                                            <td>{$row['keterangan']}</td>
                                            <td class='text-end pe-3 fw-bold $warna'>Rp ".number_format($row['nominal'],0,',','.')."</td>
                                          </tr>";
                                }
                            } else {
                                echo "<tr><td colspan='4' class='text-center py-4 text-muted'>Belum ada mutasi hari ini.</td></tr>";
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>