<?php
session_start();

// 1. KEAMANAN: Cek Login & Role Admin
if(!isset($_SESSION['status']) || $_SESSION['status'] != "sudah_login"){ 
    header("location:login.php"); 
    exit(); 
}
if(isset($_SESSION['role']) && $_SESSION['role'] != "admin"){ 
    echo "<script>alert('Akses Ditolak! Hanya Admin yang boleh masuk.'); window.location='kasir.php';</script>"; 
    exit(); 
}

include 'koneksi.php';
include 'sidebar.php'; 

// --- 2. LOGIKA SIMPAN PENGATURAN ---
if(isset($_POST['simpan'])){
    $nama   = mysqli_real_escape_string($koneksi, $_POST['nama_toko']);
    $alamat = mysqli_real_escape_string($koneksi, $_POST['alamat']);
    $telp   = mysqli_real_escape_string($koneksi, $_POST['no_telp']);
    $footer = mysqli_real_escape_string($koneksi, $_POST['footer_struk']);

    // LOGIKA UPLOAD LOGO
    $query_logo = ""; 
    if(!empty($_FILES['logo']['name'])){
        $nama_file = time() . '_' . $_FILES['logo']['name']; // Rename biar unik
        $tmp_file  = $_FILES['logo']['tmp_name'];
        $path      = "images/" . $nama_file;

        // Buat folder images jika belum ada
        if(!is_dir("images")){ mkdir("images", 0777, true); }

        if(move_uploaded_file($tmp_file, $path)){
            $query_logo = ", logo='$nama_file'";
        } else {
            echo "<script>alert('Gagal upload gambar. Pastikan folder images ada dan writable.');</script>";
        }
    }

    // Cek apakah data sudah ada di database?
    $cek = mysqli_query($koneksi, "SELECT id FROM settings LIMIT 1");
    if(mysqli_num_rows($cek) > 0){
        $d = mysqli_fetch_assoc($cek);
        $id_target = $d['id'];
        
        // UPDATE DATA LAMA
        $query = "UPDATE settings SET 
                  nama_toko='$nama', 
                  alamat='$alamat', 
                  no_telp='$telp', 
                  footer_struk='$footer' 
                  $query_logo 
                  WHERE id='$id_target'";
    } else {
        // INSERT DATA BARU (Jika tabel kosong)
        $query = "INSERT INTO settings (nama_toko, alamat, no_telp, footer_struk) 
                  VALUES ('$nama', '$alamat', '$telp', '$footer')";
    }

    if(mysqli_query($koneksi, $query)){
        echo "<script>alert('Pengaturan Berhasil Disimpan!'); window.location='admin_setting.php';</script>";
    } else {
        echo "<div class='alert alert-danger'>Gagal Update Database: ".mysqli_error($koneksi)."</div>";
    }
}

// --- 3. AMBIL DATA SAAT INI UNTUK DITAMPILKAN DI FORM ---
$q_data = mysqli_query($koneksi, "SELECT * FROM settings LIMIT 1");
$d = mysqli_fetch_assoc($q_data);

// Default value jika database kosong
$nama_toko = $d['nama_toko'] ?? 'NAMA RESTORAN';
$alamat    = $d['alamat'] ?? 'Alamat Belum Diatur';
$telp      = $d['no_telp'] ?? '';
$footer    = $d['footer_struk'] ?? 'Terima Kasih';
$logo      = $d['logo'] ?? '';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h3 class="fw-bold text-dark mb-0">⚙️ Pengaturan Toko</h3>
        <span class="text-muted">Ubah identitas restoran & manajemen data</span>
    </div>
</div>

<div class="row">
    <div class="col-md-7 mb-4">
        
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-header bg-white py-3 border-bottom">
                <h6 class="fw-bold text-primary mb-0"><i class="fas fa-store me-2"></i> Identitas Restoran</h6>
            </div>
            <div class="card-body p-4">
                <form method="POST" action="" enctype="multipart/form-data">
                    
                    <div class="mb-3">
                        <label class="form-label small fw-bold text-secondary">NAMA RESTORAN</label>
                        <input type="text" name="nama_toko" id="nama" class="form-control" value="<?= htmlspecialchars($nama_toko); ?>" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label small fw-bold text-secondary">ALAMAT LENGKAP</label>
                        <textarea name="alamat" id="alamat" class="form-control" rows="3" required><?= htmlspecialchars($alamat); ?></textarea>
                    </div>

                    <div class="mb-3">
                        <label class="form-label small fw-bold text-secondary">NO. TELEPON</label>
                        <input type="text" name="no_telp" id="telp" class="form-control" value="<?= htmlspecialchars($telp); ?>">
                    </div>

                    <div class="mb-3">
                        <label class="form-label small fw-bold text-secondary">FOOTER STRUK (Pesan Bawah)</label>
                        <input type="text" name="footer_struk" id="footer" class="form-control" value="<?= htmlspecialchars($footer); ?>" required>
                    </div>

                    <div class="mb-4 bg-light p-3 rounded border">
                        <label class="form-label small fw-bold text-secondary">LOGO TOKO (Opsional)</label>
                        <input type="file" name="logo" class="form-control mb-2" accept="image/*">
                        <div class="form-text small text-muted">* Format: JPG/PNG. Maks 2MB.</div>
                        
                        <?php if(!empty($logo) && file_exists("images/$logo")){ ?>
                            <div class="mt-2 d-flex align-items-center">
                                <img src="images/<?= $logo; ?>" style="height:50px; width:auto; border:1px solid #ddd; padding:2px; background:white; border-radius:5px;">
                                <span class="ms-2 small text-success fw-bold"><i class="fas fa-check-circle"></i> Logo Aktif</span>
                            </div>
                        <?php } ?>
                    </div>

                    <div class="d-grid">
                        <button type="submit" name="simpan" class="btn btn-primary fw-bold py-2">
                            <i class="fas fa-save me-2"></i> SIMPAN PERUBAHAN
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <div class="card border-0 shadow-sm mt-4 border-danger border-start border-3">
            <div class="card-header bg-danger text-white py-3">
                <h6 class="fw-bold mb-0"><i class="fas fa-exclamation-triangle me-2"></i> ZONA BAHAYA (RESET DATA)</h6>
            </div>
            <div class="card-body p-4">
                <div class="alert alert-warning small border-0 bg-warning bg-opacity-10 text-dark">
                    <i class="fas fa-info-circle me-1"></i> Fitur ini digunakan saat tahap pengembangan atau jika Anda ingin memulai pembukuan baru. <b>Data yang dihapus tidak bisa dikembalikan.</b>
                </div>

                <div class="d-grid gap-2">
                    <a href="reset_data.php?aksi=transaksi" onclick="return confirm('Hapus semua riwayat penjualan? Stok produk TIDAK akan kembali.')" class="btn btn-outline-danger text-start">
                        <i class="fas fa-shopping-cart me-2" style="width:20px"></i> Reset Riwayat Penjualan
                    </a>

                    <a href="reset_data.php?aksi=pengeluaran" onclick="return confirm('Hapus semua data pengeluaran operasional?')" class="btn btn-outline-danger text-start">
                        <i class="fas fa-receipt me-2" style="width:20px"></i> Reset Data Pengeluaran
                    </a>
                    
                    <a href="reset_data.php?aksi=hapus_setoran" onclick="return confirm('Yakin hapus riwayat Setor & Tarik Bank?\n\n- Saldo Bank akan dihitung ulang\n- Saldo Laci akan kembali seperti sebelum disetor.')" class="btn btn-outline-danger text-start">
                        <i class="fas fa-university me-2" style="width:20px"></i> Reset Mutasi Bank (Setor/Tarik)
                    </a>

                    <a href="reset_data.php?aksi=absensi" onclick="return confirm('Hapus semua data kehadiran karyawan?')" class="btn btn-outline-danger text-start">
                        <i class="fas fa-user-clock me-2" style="width:20px"></i> Reset Data Absensi
                    </a>

                    <div class="border-top my-2"></div>

                    <a href="reset_data.php?aksi=full_reset" onclick="return confirm('PERINGATAN KERAS!!\n\nSemua data (Transaksi, Absen, Pengeluaran, Setoran Bank) akan dihapus PERMANEN.\n\nAnda akan memulai aplikasi dari NOL.\n\nLanjutkan?')" class="btn btn-danger fw-bold">
                        <i class="fas fa-bomb me-2"></i> RESET TOTAL APLIKASI
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-5">
        <div class="card border-0 shadow-sm bg-light sticky-top" style="top: 20px; z-index: 1;">
            <div class="card-header bg-white border-bottom text-center">
                 <h6 class="fw-bold text-uppercase text-muted mb-0">Preview Struk</h6>
            </div>
            <div class="card-body text-center p-4 font-monospace" style="border: 1px dashed #ccc; min-height: 400px; background-color: #fffdf8;">
               
                <div class="mb-3">
                    <?php if(!empty($logo) && file_exists("images/$logo")){ ?>
                        <img src="images/<?= $logo; ?>" id="prev-img" style="max-height:80px; width:auto; filter: grayscale(100%);">
                    <?php } else { ?>
                        <i class="fas fa-store fa-3x text-muted opacity-25"></i>
                    <?php } ?>
                </div>

                <div id="prev-nama" class="fw-bold fs-5 mb-1 text-dark"><?= strtoupper($nama_toko); ?></div>
                <div id="prev-alamat" class="small text-muted mb-1"><?= $alamat; ?></div>
                <div id="prev-telp" class="small text-muted mb-3">Telp: <?= $telp; ?></div>
                
                <div class="mb-2 border-top border-bottom py-1 text-muted" style="border-style: dashed !important;">
                    --------------------------------
                </div>
                
                <div class="text-start small text-muted px-4">
                    <div class="d-flex justify-content-between">
                        <span>Ayam Bakar</span> <span>15.000</span>
                    </div>
                    <div class="d-flex justify-content-between">
                        <span>Es Teh Manis</span> <span>5.000</span>
                    </div>
                    <div class="d-flex justify-content-between fw-bold mt-1 pt-1 border-top">
                        <span>TOTAL</span> <span>20.000</span>
                    </div>
                </div>

                <div class="mb-2 mt-2 border-top border-bottom py-1 text-muted" style="border-style: dashed !important;">
                    --------------------------------
                </div>

                <div id="prev-footer" class="small fst-italic text-dark mt-3"><?= $footer; ?></div>
                <div class="small text-muted mt-1">Wifi: Berkah_Resto / 12345678</div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>

<script>
    function updatePreview(){
        // Update Nama
        let nama = document.getElementById('nama').value;
        document.getElementById('prev-nama').innerText = nama ? nama.toUpperCase() : "NAMA RESTORAN";

        // Update Alamat
        document.getElementById('prev-alamat').innerText = document.getElementById('alamat').value;

        // Update Telp
        let telp = document.getElementById('telp').value;
        document.getElementById('prev-telp').innerText = telp ? "Telp: " + telp : "";

        // Update Footer
        document.getElementById('prev-footer').innerText = document.getElementById('footer').value;
    }

    // Pasang Event Listener
    ['nama', 'alamat', 'telp', 'footer'].forEach(id => {
        document.getElementById(id).addEventListener('input', updatePreview);
    });
</script>