<?php
if (session_status() == PHP_SESSION_NONE) { session_start(); }
if(!isset($_SESSION['status'])){ header("location:login.php"); exit(); }
if($_SESSION['role'] != 'admin'){ header("location:kasir.php"); exit(); }

include 'koneksi.php';
include 'sidebar.php'; 
?>

<h3 class="mb-4 fw-bold text-primary"><i class="fas fa-users-cog me-2"></i> Manajemen Karyawan & User</h3>

<div class="card border-0 shadow-sm mb-4">
    <div class="card-body">
        <button type="button" class="btn btn-primary mb-3" onclick="tambahData()">
            <i class="fas fa-user-plus"></i> Tambah Karyawan Baru
        </button>

        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead class="table-light">
                    <tr>
                        <th>No</th>
                        <th>Nama & Role</th>
                        <th>Kontak & Gaji</th>
                        <th>ID Kartu (RFID)</th>
                        <th>Status</th>
                        <th class="text-center">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $no = 1;
                    $query = mysqli_query($koneksi, "SELECT * FROM users ORDER BY is_active DESC, role ASC");
                    while($row = mysqli_fetch_assoc($query)){
                        $status_badge = ($row['is_active'] == 1) 
                            ? '<span class="badge bg-success">Aktif</span>' 
                            : '<span class="badge bg-secondary">Non-Aktif</span>';
                        
                        if($row['role'] == 'admin'){
                            $role_badge = '<span class="badge bg-primary">ADMIN</span>';
                        } elseif($row['role'] == 'koki'){
                            $role_badge = '<span class="badge bg-warning text-dark">KOKI</span>';
                        } elseif($row['role'] == 'waiter'){
                            $role_badge = '<span class="badge bg-success">WAITER</span>';
                        } else {
                            $role_badge = '<span class="badge bg-info text-dark">KASIR</span>';
                        }

                        $kartu = $row['rfid_uid'];
                        $badge_kartu = empty($kartu) 
                            ? '<span class="text-muted small fst-italic">Belum ada kartu</span>' 
                            : '<code class="text-primary fw-bold">'.$kartu.'</code>';
                    ?>
                    <tr class="<?= ($row['is_active'] == 0) ? 'table-secondary text-muted' : ''; ?>">
                        <td><?= $no++; ?></td>
                        <td>
                            <div class="fw-bold"><?= $row['nama_lengkap']; ?></div>
                            <small class="text-muted"><i class="fas fa-user-circle me-1"></i> <?= $row['username']; ?></small>
                            <div class="mt-1"><?= $role_badge; ?></div>
                        </td>
                        <td>
                            <small class="d-block"><i class="fas fa-phone me-1"></i> <?= $row['no_hp'] ?: '-'; ?></small>
                            <small class="d-block text-success fw-bold"><i class="fas fa-money-bill me-1"></i> Rp <?= number_format($row['gaji_pokok'], 0, ',', '.'); ?></small>
                        </td>
                        <td><?= $badge_kartu; ?></td>
                        <td><?= $status_badge; ?></td>
                        <td class="text-center">
                            <button class="btn btn-sm btn-warning text-white" 
                                onclick="editData(
                                    '<?= $row['id']; ?>',
                                    '<?= htmlspecialchars($row['username']); ?>',
                                    '<?= htmlspecialchars($row['nama_lengkap']); ?>',
                                    '<?= $row['role']; ?>',
                                    '<?= $row['no_hp']; ?>',
                                    '<?= $row['gaji_pokok']; ?>',
                                    '<?= $row['rfid_uid']; ?>', 
                                    '<?= $row['is_active']; ?>'
                                )">
                                <i class="fas fa-edit"></i>
                            </button>
                            
                            <?php if($_SESSION['username'] != $row['username']){ ?>
                                <a href="kelola_user.php?aksi=hapus&id=<?= $row['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Yakin hapus user ini?')">
                                    <i class="fas fa-trash"></i>
                                </a>
                            <?php } ?>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<div class="modal fade" id="modalUser" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title fw-bold" id="modalTitle">Tambah Karyawan</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="kelola_user.php" method="POST">
                <div class="modal-body">
                    <input type="hidden" name="id" id="id_user">
                    <input type="hidden" name="aksi" id="form_aksi" value="tambah">

                    <div class="mb-3">
                        <label class="form-label fw-bold">Nama Lengkap</label>
                        <input type="text" name="nama_lengkap" id="nama_lengkap" class="form-control" required>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Username</label>
                            <input type="text" name="username" id="username" class="form-control" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Password</label>
                            <input type="password" name="password" id="password" class="form-control" placeholder="(Kosongkan jika tidak ubah)">
                        </div>
                    </div>

                    <div class="mb-3 bg-light p-3 rounded border">
                        <label class="form-label fw-bold text-primary"><i class="fas fa-id-card me-2"></i>Kode Kartu RFID (UID)</label>
                        <input type="text" name="rfid_uid" id="rfid_uid" class="form-control font-monospace mb-1" placeholder="Tempel kartu..." style="text-transform: uppercase;" readonly>
                        <div id="rfid_status" class="small text-muted fst-italic">Menunggu tap kartu...</div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">No. HP</label>
                            <input type="number" name="no_hp" id="no_hp" class="form-control">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Gaji Pokok</label>
                            <input type="number" name="gaji_pokok" id="gaji_pokok" class="form-control" value="0">
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Jabatan / Role</label>
                        <select name="role" id="role" class="form-select">
                            <option value="kasir">Kasir / Staff</option>
                            <option value="koki">Koki / Dapur</option>
                            <option value="waiter">Waiter / Pelayan</option>
                            <option value="admin">Admin / Pemilik</option>
                        </select>
                    </div>

                    <div class="mb-3 form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1" checked>
                        <label class="form-check-label fw-bold" for="is_active">Status Aktif</label>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Simpan Data</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>

<script>
    const modal = new bootstrap.Modal(document.getElementById('modalUser'));
    let scanInterval;

    function tambahData(){
        document.getElementById('modalTitle').innerText = "Tambah Karyawan Baru";
        document.getElementById('form_aksi').value = "tambah";
        document.getElementById('id_user').value = "";
        
        document.getElementById('nama_lengkap').value = "";
        document.getElementById('username').value = "";
        document.getElementById('password').value = "";
        document.getElementById('no_hp').value = "";
        document.getElementById('gaji_pokok').value = "0";
        document.getElementById('role').value = "kasir";
        document.getElementById('is_active').checked = true;

        // Reset UID
        document.getElementById('rfid_uid').value = "";
        document.getElementById('rfid_status').innerHTML = '<span class="spinner-border spinner-border-sm text-primary"></span> Menunggu tap kartu...';
        
        modal.show();
        mulaiScanning();
    }

    // PERHATIKAN URUTAN PARAMETER DI SINI HARUS SAMA DENGAN PHP DI ATAS
    function editData(id, username, nama, role, hp, gaji, uid, active){
        document.getElementById('modalTitle').innerText = "Edit Data Karyawan";
        document.getElementById('form_aksi').value = "edit";
        document.getElementById('id_user').value = id;
        
        document.getElementById('nama_lengkap').value = nama;
        document.getElementById('username').value = username;
        document.getElementById('role').value = role;
        document.getElementById('no_hp').value = hp;
        document.getElementById('gaji_pokok').value = gaji;
        
        // PASTIKAN UID TERISI
        document.getElementById('rfid_uid').value = uid; 
        
        document.getElementById('is_active').checked = (active == 1);
        document.getElementById('password').value = ""; 

        // Status UID
        if(uid){
            document.getElementById('rfid_status').innerHTML = '<span class="text-success fw-bold"><i class="fas fa-check"></i> UID Terisi (Siap ditap jika ingin ganti)</span>';
        } else {
            document.getElementById('rfid_status').innerHTML = '<span class="spinner-border spinner-border-sm text-primary"></span> Menunggu tap kartu...';
        }

        modal.show();
        mulaiScanning();
    }

    function mulaiScanning(){
        clearInterval(scanInterval);
        scanInterval = setInterval(() => {
            fetch('cek_scan_baru.php')
                .then(response => response.json())
                .then(data => {
                    if(data.status == "ada"){
                        let inputUID = document.getElementById('rfid_uid');
                        if(inputUID.value != data.uid){
                            inputUID.value = data.uid;
                            inputUID.style.backgroundColor = "#d4edda";
                            setTimeout(() => { inputUID.style.backgroundColor = "white"; }, 500);
                            document.getElementById('rfid_status').innerHTML = '<span class="fw-bold text-success"><i class="fas fa-check-circle"></i> Kartu Baru Terdeteksi!</span>';
                        }
                    }
                });
        }, 1000); 
    }

    document.getElementById('modalUser').addEventListener('hidden.bs.modal', function () {
        clearInterval(scanInterval);
    });
</script>