<?php
// Header JSON Wajib untuk API
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json; charset=utf-8');

include 'koneksi.php';
date_default_timezone_set('Asia/Jakarta');

// 1. Tangkap Data dari ESP32 (Method POST)
// Ganti $_POST menjadi $_REQUEST agar bisa dites lewat Browser (GET) maupun ESP32 (POST)
$uid = isset($_REQUEST['uid']) ? mysqli_real_escape_string($koneksi, $_REQUEST['uid']) : '';

if(empty($uid)){
    echo json_encode(["status" => "error", "pesan" => "UID Kosong"]);
    exit();
}

// 2. Cek Kartu Milik Siapa?
$cek_user = mysqli_query($koneksi, "SELECT * FROM users WHERE rfid_uid = '$uid' AND is_active = 1");
$user = mysqli_fetch_assoc($cek_user);

if(!$user){
    // === PERBAIKAN LOGIKA ===
    // Update ID 1 saja (jangan insert baru)
    // Kita update 'waktu' ke NOW() agar terdeteksi sebagai data baru
    $update_temp = "UPDATE temp_rfid SET uid='$uid', waktu=NOW() WHERE id=1";
    mysqli_query($koneksi, $update_temp);
    
    // Cek apakah berhasil update (untuk debugging)
    if(mysqli_affected_rows($koneksi) <= 0){
        // Jika gagal update (misal tabel kosong), kita insert paksa ID=1
        mysqli_query($koneksi, "INSERT INTO temp_rfid (id, uid, waktu) VALUES (1, '$uid', NOW())");
    }
    
    echo json_encode(["status" => "warning", "pesan" => "Kartu Belum Terdaftar"]);
    exit();
}

$user_id = $user['id'];
$nama    = $user['nama_lengkap'];
$tanggal = date('Y-m-d');
$waktu   = date('H:i:s');

// 3. Cek Status Absen Hari Ini
$cek_absen = mysqli_query($koneksi, "SELECT * FROM attendance WHERE user_id = '$user_id' AND tanggal = '$tanggal'");
$data_absen = mysqli_fetch_assoc($cek_absen);

if(!$data_absen){
    // A. BELUM ABSEN -> LAKUKAN ABSEN MASUK
    
    // Logika Telat (Misal lewat jam 08:00)
    $status_kehadiran = 'hadir';
    if($waktu > '08:00:00') { $status_kehadiran = 'telat'; }

    $insert = "INSERT INTO attendance (user_id, tanggal, jam_masuk, status) VALUES ('$user_id', '$tanggal', '$waktu', '$status_kehadiran')";
    
    if(mysqli_query($koneksi, $insert)){
        echo json_encode([
            "status" => "sukses", 
            "mode" => "masuk", 
            "nama" => $nama, 
            "jam" => $waktu,
            "pesan" => "Selamat Pagi, $nama"
        ]);
    } else {
        echo json_encode(["status" => "error", "pesan" => "Gagal SQL Masuk"]);
    }

} else {
    // B. SUDAH ABSEN MASUK
    
    if($data_absen['jam_pulang'] == NULL){
        // B.1 -> LAKUKAN ABSEN PULANG
        $update = "UPDATE attendance SET jam_pulang = '$waktu' WHERE id = '{$data_absen['id']}'";
        
        if(mysqli_query($koneksi, $update)){
            echo json_encode([
                "status" => "sukses", 
                "mode" => "pulang", 
                "nama" => $nama, 
                "pesan" => "Hati-hati, $nama"
            ]);
        }
    } else {
        // B.2 -> SUDAH PULANG (Tolak Double Tap)
        echo json_encode([
            "status" => "warning", 
            "pesan" => "Sudah Selesai Hari Ini"
        ]);
    }
}
?>