<?php
include 'koneksi.php';
date_default_timezone_set('Asia/Jakarta');
?>

<!DOCTYPE html>
<html>
<head>
    <title>Detektif Saldo Bank</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="p-4 bg-light">

<div class="container">
    <h2 class="mb-4">🕵️‍♂️ Detektif Rincian Saldo Bank</h2>

    <div class="card mb-4 border-0 shadow-sm">
        <div class="card-header bg-primary text-white fw-bold">
            1. Sumber: Penjualan Non-Tunai (QRIS/Transfer)
        </div>
        <div class="card-body">
            <table class="table table-bordered table-sm">
                <thead>
                    <tr>
                        <th>Tanggal</th>
                        <th>Kode TRX</th>
                        <th>Metode</th>
                        <th class="text-end">Total</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $q1 = mysqli_query($koneksi, "SELECT * FROM transactions WHERE status='paid' AND metode_bayar != 'cash' AND metode_bayar IS NOT NULL ORDER BY id DESC");
                    $total1 = 0;
                    while($r = mysqli_fetch_assoc($q1)){
                        $total1 += $r['total_bayar'];
                        echo "<tr>
                            <td>{$r['tanggal_buat']}</td>
                            <td>{$r['kode_transaksi']}</td>
                            <td><span class='badge bg-info'>{$r['metode_bayar']}</span></td>
                            <td class='text-end'>".number_format($r['total_bayar'])."</td>
                        </tr>";
                    }
                    ?>
                    <tr class="fw-bold bg-light">
                        <td colspan="3" class="text-end">SUBTOTAL PENJUALAN:</td>
                        <td class="text-end text-primary">Rp <?= number_format($total1); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <div class="card mb-4 border-0 shadow-sm">
        <div class="card-header bg-success text-white fw-bold">
            2. Sumber: Setoran Tunai Admin (Laci ke Bank)
        </div>
        <div class="card-body">
            <table class="table table-bordered table-sm">
                <thead>
                    <tr>
                        <th>Tanggal Input</th>
                        <th>Keterangan</th>
                        <th class="text-end">Nominal</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $q2 = mysqli_query($koneksi, "SELECT * FROM cash_flows WHERE jenis='setor_bank' ORDER BY id DESC");
                    $total2 = 0;
                    while($r = mysqli_fetch_assoc($q2)){
                        $total2 += $r['nominal'];
                        // Cek apakah tanggalnya hari ini?
                        $is_today = (date('Y-m-d', strtotime($r['tanggal'])) == date('Y-m-d')) ? '<span class="badge bg-success">HARI INI</span>' : '<span class="badge bg-secondary">LAMA</span>';
                        
                        echo "<tr>
                            <td>{$r['tanggal']} $is_today</td>
                            <td>{$r['keterangan']}</td>
                            <td class='text-end'>".number_format($r['nominal'])."</td>
                        </tr>";
                    }
                    ?>
                    <tr class="fw-bold bg-light">
                        <td colspan="2" class="text-end">SUBTOTAL SETORAN:</td>
                        <td class="text-end text-success">Rp <?= number_format($total2); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <div class="card mb-4 border-0 shadow-sm">
        <div class="card-header bg-danger text-white fw-bold">
            3. Pengurang: Pengeluaran via Transfer Bank
        </div>
        <div class="card-body">
            <?php
            $q3 = mysqli_query($koneksi, "SELECT SUM(nominal) as total FROM expenses WHERE sumber_dana = 'bank'");
            $d3 = mysqli_fetch_assoc($q3);
            $total3 = $d3['total'] ?? 0;
            ?>
            <h4 class="text-danger mb-0">- Rp <?= number_format($total3); ?></h4>
        </div>
    </div>

    <div class="alert alert-warning text-center fw-bold fs-4">
        TOTAL AKHIR: ( <?= number_format($total1); ?> + <?= number_format($total2); ?> ) - <?= number_format($total3); ?> = Rp <?= number_format(($total1+$total2)-$total3); ?>
    </div>

</div>
</body>
</html>