<?php
header('Content-Type: text/plain');

// Cek file koneksi ada di mana
if(file_exists('../koneksi.php')) {
    include '../koneksi.php';
    echo "[INFO] Menggunakan koneksi dari folder luar (../koneksi.php)\n";
} elseif(file_exists('koneksi.php')) {
    include 'koneksi.php';
    echo "[INFO] Menggunakan koneksi dari folder api (koneksi.php)\n";
} else {
    die("[FATAL] File koneksi.php TIDAK DITEMUKAN dimanapun!");
}

// 1. Cek Nama Database yang Aktif
$q_db = mysqli_query($koneksi, "SELECT DATABASE() as nama_db");
$row_db = mysqli_fetch_assoc($q_db);
echo "Database Aktif: " . $row_db['nama_db'] . "\n\n";

// 2. Daftar Semua Tabel yang Ada
echo "=== DAFTAR TABEL DI DATABASE INI ===\n";
$q_tables = mysqli_query($koneksi, "SHOW TABLES");
if($q_tables) {
    while($row = mysqli_fetch_row($q_tables)) {
        echo "- " . $row[0] . "\n";
    }
} else {
    echo "Gagal mengambil daftar tabel: " . mysqli_error($koneksi);
}

// 3. Tes Spesifik Tabel 'products'
echo "\n=== PENGECEKAN TABEL 'products' ===\n";
$cek = mysqli_query($koneksi, "SELECT count(*) FROM products");
if($cek) {
    echo "STATUS: AMAN. Tabel ditemukan.\n";
} else {
    echo "STATUS: ERROR. Tabel 'products' TIDAK DITEMUKAN.\n";
    echo "Pesan Error MySQL: " . mysqli_error($koneksi) . "\n";
}
?>