<?php
include '../koneksi.php';

// Set Timezone agar sama dengan inputan
date_default_timezone_set('Asia/Jakarta');

$start = date('Y-m-01'); // Awal bulan ini
$end   = date('Y-m-d');  // Hari ini

echo "<h3>Diagnosa Omzet ($start s/d $end)</h3>";

// 1. Cek Apakah Ada Data Transaksi Sama Sekali?
$cek_data = mysqli_query($koneksi, "SELECT * FROM transactions LIMIT 5");
echo "<b>1. Contoh Data di Database:</b><br>";
if(mysqli_num_rows($cek_data) > 0){
    while($row = mysqli_fetch_assoc($cek_data)){
        echo "- ID: {$row['id']} | Tgl: {$row['tanggal_buat']} | Total: {$row['total_bayar']} (Tipe data: " . gettype($row['total_bayar']) . ")<br>";
    }
} else {
    echo "TIDAK ADA DATA SAMA SEKALI.<br>";
}
echo "<hr>";

// 2. Cek Query SUM
$start_time = $start . " 00:00:00";
$end_time   = $end . " 23:59:59";

$sql = "SELECT SUM(total_bayar) as omzet FROM transactions WHERE tanggal_buat BETWEEN '$start_time' AND '$end_time'";
$q = mysqli_query($koneksi, $sql);
$d = mysqli_fetch_assoc($q);

echo "<b>2. Hasil Perhitungan SQL:</b><br>";
echo "Query: $sql <br>";
echo "Hasil SUM: <b>" . ($d['omzet'] === NULL ? "NULL (Kosong)" : $d['omzet']) . "</b><br>";

if($d['omzet'] == 0 || $d['omzet'] == NULL){
    echo "<span style='color:red'>KENAPA 0?</span><br>";
    echo "a. Pastikan kolom 'tanggal_buat' di database formatnya 'YYYY-MM-DD HH:MM:SS'.<br>";
    echo "b. Pastikan kolom 'total_bayar' isinya angka murni tanpa titik/koma.<br>";
} else {
    echo "<span style='color:green'>Data ditemukan! Masalah mungkin ada di file get_laporan_detail.php</span>";
}
?>