<?php
session_start();
include 'koneksi.php';

if(!isset($_SESSION['status']) || $_SESSION['role'] != 'admin'){ header("location:login.php"); exit(); }

$id = isset($_GET['id']) ? $_GET['id'] : '';

// 1. AMBIL DATA
$query = "SELECT p.*, u.nama_lengkap, u.role 
          FROM payroll p 
          JOIN users u ON p.user_id = u.id 
          WHERE p.id = '$id'";

$result = mysqli_query($koneksi, $query);
$data   = mysqli_fetch_assoc($result);

if(!$data){ echo "Data slip tidak ditemukan."; exit(); }

// 2. FORMAT DATA
$nama_toko = "VEGAMEDI RESTO";
$alamat_toko = "Jl. Contoh No. 123";
$tanggal = date('d/m/Y H:i');
$nama = strtoupper($data['nama_lengkap']);
$jabatan = strtoupper($data['role']);

// Format Periode
if($data['jenis_periode'] == 'bulanan'){
    $periode = date('F Y', strtotime($data['tgl_awal'])); 
} else {
    $periode = date('d/m', strtotime($data['tgl_awal'])) . " - " . date('d/m', strtotime($data['tgl_akhir']));
}

$hadir = $data['jumlah_hadir'];
$harian = number_format($data['gaji_harian'], 0, ',', '.');
$total = number_format($data['total_gaji'], 0, ',', '.');
$garis = "--------------------------------"; // Sesuaikan panjang printer (32 char untuk 58mm)

// 3. SUSUN STRUK FORMAT RAWBT
// [C] = Center, [L] = Left, [R] = Right, [B] = Bold
$struk  = "[C]<b>$nama_toko</b>\n";
$struk .= "[C]$alamat_toko\n";
$struk .= "[L]\n";
$struk .= "[C]<b>SLIP GAJI KARYAWAN</b>\n";
$struk .= "[L]$garis\n";
$struk .= "[L]Tanggal : $tanggal\n";
$struk .= "[L]Nama    : $nama\n";
$struk .= "[L]Jabatan : $jabatan\n";
$struk .= "[L]Periode : $periode\n";
$struk .= "[L]$garis\n";
$struk .= "[L]RINCIAN:\n";
$struk .= "[L]Hadir   : $hadir Hari\n";
$struk .= "[L]Gaji    : Rp $harian /hari\n";
$struk .= "[L]$garis\n";
$struk .= "[R]TOTAL DITERIMA :\n";
$struk .= "[R]<b>Rp $total</b>\n";
$struk .= "[L]$garis\n";
$struk .= "[C]Diterima Oleh,\n";
$struk .= "\n\n"; // Spasi tanda tangan
$struk .= "[C]( $nama )\n";
$struk .= "[C]Simpan struk ini sebagai bukti.\n";
$struk .= "\n\n"; // Feed kertas bawah

// 4. ENCODE KE BASE64 (Agar bisa dikirim lewat URL)
$struk_base64 = base64_encode($struk);
$url_rawbt = "rawbt:base64," . $struk_base64;
?>

<!DOCTYPE html>
<html>
<head>
    <title>Cetak RawBT</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body { font-family: sans-serif; text-align: center; padding-top: 50px; }
        .btn {
            background-color: #4CAF50; color: white; padding: 15px 32px;
            text-align: center; text-decoration: none; display: inline-block;
            font-size: 16px; border-radius: 8px; border: none; cursor: pointer;
        }
    </style>
</head>
<body>

    <h3>Sedang Mengirim ke Printer...</h3>
    <p>Jika tidak otomatis, klik tombol di bawah:</p>
    
    <a href="<?php echo $url_rawbt; ?>" id="link_print" class="btn">🖨️ CETAK SEKARANG</a>

    <script>
        // Otomatis klik tombol saat halaman dimuat
        window.onload = function() {
            // Beri jeda sedikit agar halaman loading dulu
            setTimeout(function(){
                document.getElementById('link_print').click();
                
                // Opsional: Tutup tab otomatis setelah 3 detik
                // setTimeout(function(){ window.close(); }, 3000);
            }, 500);
        };
    </script>

</body>
</html>
