<?php
include 'koneksi.php';

// 1. AMBIL PENGATURAN TOKO DARI DATABASE
$q_toko = mysqli_query($koneksi, "SELECT * FROM settings LIMIT 1");
$d_toko = mysqli_fetch_assoc($q_toko);

$nama_toko   = $d_toko['nama_toko'] ?? 'NAMA RESTO';
$alamat_toko = $d_toko['alamat'] ?? 'Alamat Belum Diatur';
$footer_struk= $d_toko['footer_struk'] ?? 'Terima Kasih';

// 2. AMBIL DATA TRANSAKSI
$id_trx = $_GET['id']; // ID Transaksi
$q_trx  = mysqli_query($koneksi, "SELECT * FROM transactions WHERE id='$id_trx'");
$trx    = mysqli_fetch_assoc($q_trx);

// Ambil Detail Item
$q_item = mysqli_query($koneksi, "SELECT * FROM transaction_items WHERE transaction_id='$id_trx'");

// 3. FORMAT TEXT RAWBT
$garis = "--------------------------------"; 
$struk  = "[C]<b>$nama_toko</b>\n";     // <-- Pakai variabel database
$struk .= "[C]$alamat_toko\n";         // <-- Pakai variabel database
$struk .= "[L]\n";
$struk .= "[L]No: {$trx['kode_transaksi']}\n";
$struk .= "[L]Tgl: ".date('d-m-Y H:i', strtotime($trx['tanggal_buat']))."\n";
$struk .= "[L]Kasir: {$trx['kasir_nama']}\n";
$struk .= "[L]$garis\n";

// Loop Item
while($item = mysqli_fetch_assoc($q_item)){
    $struk .= "[L]<b>{$item['nama_produk_snapshot']}</b>\n";
    $struk .= "[L]{$item['qty']} x ".number_format($item['harga_snapshot'],0,',','.')." [R]".number_format($item['subtotal'],0,',','.')."\n";
}

$struk .= "[L]$garis\n";
$struk .= "[R]TOTAL : <b>Rp ".number_format($trx['total_bayar'],0,',','.')."</b>\n";
$struk .= "[L]Bayar : Rp ".number_format($trx['bayar'],0,',','.')."\n";
$struk .= "[L]Kembali : Rp ".number_format($trx['kembali'],0,',','.')."\n";
$struk .= "[L]$garis\n";
$struk .= "[C]$footer_struk\n";        // <-- Pakai variabel database
$struk .= "\n\n"; 

// 4. KIRIM KE RAWBT
$struk_base64 = base64_encode($struk);
$url_rawbt = "rawbt:base64," . $struk_base64;
?>

<!DOCTYPE html>
<html>
<head><title>Print Struk</title></head>
<body>
    <a href="<?php echo $url_rawbt; ?>" id="btn_print">CETAK</a>
    <script>
        document.getElementById('btn_print').click();
        setTimeout(function(){ window.close(); }, 1000);
    </script>
</body>
</html>