<?php
session_start();
// Pastikan user sudah login
if(!isset($_SESSION['status']) || $_SESSION['status'] != "sudah_login"){ header("location:login.php"); exit(); }
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kitchen Display System</title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800&display=swap" rel="stylesheet">

    <style>
        :root {
            --bg-dark: #0f172a;       /* Slate-900 */
            --card-bg: #1e293b;       /* Slate-800 */
            --text-main: #f1f5f9;     /* Slate-100 */
            --text-muted: #94a3b8;    /* Slate-400 */
            --border-color: #334155;  /* Slate-700 */
            
            --status-new: #10b981;    /* Green */
            --status-warn: #f59e0b;   /* Orange */
            --status-late: #ef4444;   /* Red */
        }
        body { 
            background-color: var(--bg-dark); 
            color: var(--text-main); 
            font-family: 'Inter', sans-serif; 
            padding: 20px; 
            height: 100vh;
            overflow-y: auto;
        }
        
        /* HEADER */
        .header-dapur { 
            display: flex; justify-content: space-between; align-items: center; 
            padding-bottom: 20px; border-bottom: 1px solid var(--border-color); margin-bottom: 25px; 
            flex-wrap: wrap; /* Agar responsif jika layar sempit */
            gap: 15px;
        }
        
        .btn-back {
            background: white; 
            color: #0f172a; 
            border: none; 
            font-weight: 800; 
            padding: 8px 16px; /* Padding sedikit dikecilkan */
            border-radius: 8px; 
            text-decoration: none; 
            display: inline-flex; 
            align-items: center; 
            gap: 8px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
            transition: transform 0.2s;
            font-size: 0.9rem; /* Ukuran font disesuaikan */
        }
        .btn-back:hover { transform: scale(1.05); background: #e2e8f0; color: #000; }

        .header-title { font-weight: 800; letter-spacing: -0.5px; font-size: 1.5rem; display: flex; align-items: center; gap: 10px; }
        
        .clock-display { 
            font-family: monospace; font-size: 1.25rem; font-weight: 700; 
            color: var(--status-warn); background: rgba(245, 158, 11, 0.1); 
            padding: 5px 12px; border-radius: 8px; 
        }
        
        /* GRID & CARD */
        .ticket-grid { 
            display: grid; 
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)); 
            gap: 20px; 
        }
        
        /* MEDIA QUERY UNTUK MOBILE */
        @media (max-width: 576px) {
            body { padding: 10px; } /* Padding body lebih kecil di mobile */
            .header-dapur { padding-bottom: 15px; margin-bottom: 15px; }
            .header-title { font-size: 1.25rem; }
            .ticket-grid { 
                grid-template-columns: 1fr; /* 1 Kolom penuh di mobile */
                gap: 15px;
            }
            .clock-display { font-size: 1rem; }
        }
        
        .ticket-card { 
            background: var(--card-bg); border-radius: 16px; overflow: hidden; border: 1px solid var(--border-color);
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.3); display: flex; flex-direction: column;
            transition: 0.3s;
        }
        
        .status-line { height: 6px; width: 100%; }
        .status-new  { background: var(--status-new); }
        .status-warn { background: var(--status-warn); }
        .status-late { background: var(--status-late); animation: pulse 2s infinite; }
        @keyframes pulse { 0% { opacity: 1; } 50% { opacity: 0.5; } 100% { opacity: 1; } }

        .ticket-header { padding: 12px 15px; display: flex; justify-content: space-between; align-items: center; border-bottom: 1px solid var(--border-color); background: rgba(255,255,255,0.02); }
        .pager-badge { background: #fff; color: #000; font-weight: 900; font-size: 1.1rem; padding: 4px 10px; border-radius: 6px; }
        .timer-badge { font-size: 0.85rem; font-weight: 600; color: var(--text-muted); display: flex; align-items: center; gap: 5px; }
        
        .ticket-body { padding: 0; flex: 1; }
        .item-list { list-style: none; padding: 0; margin: 0; }
        .item-list li { padding: 10px 15px; border-bottom: 1px solid var(--border-color); display: flex; align-items: flex-start; gap: 12px; font-size: 1rem; line-height: 1.4; }
        .qty-box { background: rgba(255,255,255,0.1); min-width: 30px; height: 30px; display: flex; align-items: center; justify-content: center; border-radius: 6px; font-weight: 800; border: 1px solid var(--border-color); font-size: 0.9rem; }

        .btn-selesai { width: 100%; padding: 15px; border: none; background: var(--status-new); color: #000; font-weight: 800; font-size: 1rem; cursor: pointer; transition: 0.2s; letter-spacing: 1px; }
        .btn-selesai:hover { filter: brightness(1.1); }
        
        .loading-state { grid-column: 1 / -1; text-align: center; color: var(--text-muted); padding-top: 50px; }
    </style>
</head>
<body>

    <div class="header-dapur">
        <div class="header-title">
            <i class="fas fa-fire-burner text-warning"></i> KITCHEN DISPLAY
        </div>
        <div class="d-flex align-items-center gap-3">
            <a href="kasir.php" class="btn-back">
                <i class="fas fa-arrow-left"></i> KASIR
            </a>
            <div id="jam-digital" class="clock-display">00:00:00</div>
        </div>
    </div>

    <div id="ticket-container" class="ticket-grid">
        <div class="loading-state"><i class="fas fa-circle-notch fa-spin fa-3x mb-3"></i><br>Menghubungkan...</div>
    </div>

    <audio id="notif-sound" src="https://assets.mixkit.co/active_storage/sfx/2869/2869-preview.mp3"></audio>

    <script>
        // CONFIG API
        const API_BASE = window.location.protocol + '//' + window.location.hostname + '/api_kasir/';
        let lastOrderCount = 0; 

        // JAM
        setInterval(() => {
            const now = new Date();
            document.getElementById('jam-digital').innerText = now.toLocaleTimeString('id-ID', { hour12: false });
        }, 1000);

        // AUTO LOAD
        loadDapur();
        setInterval(loadDapur, 5000); 

        function loadDapur(){
            fetch(API_BASE + 'get_dapur.php')
            .then(res => res.json())
            .then(data => {
                const container = document.getElementById('ticket-container');
                
                // Bunyi jika ada order baru
                if(data.length > lastOrderCount){
                    document.getElementById('notif-sound').play().catch(()=>{});
                }
                lastOrderCount = data.length;

                if(data.length === 0){
                    container.innerHTML = `<div class="loading-state"><i class="fas fa-check-circle text-success fa-3x mb-3"></i><br><h3>Semua Pesanan Selesai!</h3></div>`;
                    return;
                }

                let html = '';
                data.forEach(trx => {
                    let statusClass = 'status-new';
                    let timeInfo = 'text-muted';
                    if(trx.durasi_menit > 15) { statusClass = 'status-warn'; timeInfo = 'text-warning'; }
                    if(trx.durasi_menit > 30) { statusClass = 'status-late'; timeInfo = 'text-danger'; }

                    let itemsHtml = '';
                    if(trx.pesanan){
                        trx.pesanan.forEach(item => {
                            itemsHtml += `<li><div class="qty-box">${item.qty}</div><div style="font-weight:600;">${item.nama}</div></li>`;
                        });
                    }

                    // Tambahkan ID unik pada card untuk animasi hapus
                    html += `
                    <div class="ticket-card" id="card-${trx.id}">
                        <div class="status-line ${statusClass}"></div>
                        <div class="ticket-header">
                            <div class="d-flex align-items-center gap-2">
                                <span class="pager-badge">#${trx.nomor_pager}</span>
                                <span class="text-muted small">Bon: ${trx.kode_transaksi}</span>
                            </div>
                            <div class="${timeInfo} fw-bold"><i class="fas fa-clock"></i> ${trx.durasi_menit} mnt</div>
                        </div>
                        <div class="ticket-body">
                            <ul class="item-list">${itemsHtml}</ul>
                        </div>
                        <button onclick="selesaiMasak(${trx.id})" class="btn-selesai">SELESAI <i class="fas fa-check ms-2"></i></button>
                    </div>`;
                });
                container.innerHTML = html;
            })
            .catch(err => console.log("Menunggu koneksi..."));
        }

        function selesaiMasak(id){
            // 1. HAPUS KARTU DULUAN (Supaya Cepat & Responsif)
            const card = document.getElementById('card-' + id);
            if(card) {
                card.style.transition = "all 0.3s";
                card.style.opacity = '0';
                card.style.transform = 'scale(0.8)';
                setTimeout(() => card.remove(), 300);
            }

            // 2. KIRIM KE SERVER (Metode POST standard)
            fetch(API_BASE + 'update_dapur.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: 'id=' + id
            })
            .then(res => res.json())
            .then(data => {
                if(data.status !== 'sukses'){
                    console.error("GAGAL UPDATE:", data.pesan);
                    alert("Gagal update status: " + data.pesan);
                }
            })
            .catch(err => {
                console.error("Error Jaringan:", err);
            });
        }
    </script>
</body>
</html>