<?php
session_start();
if(!isset($_SESSION['status']) || $_SESSION['status'] != "sudah_login"){ header("location:login.php"); exit(); }

// Cek Role (Hanya Admin)
if($_SESSION['role'] != "admin"){ 
    if($_SESSION['role'] == 'koki'){ header("location:dapur.php"); } 
    else { header("location:kasir.php"); }
    exit(); 
}

include 'koneksi.php';

// 1. SET TIMEZONE & LOGIKA PHP (TIDAK BERUBAH)
date_default_timezone_set('Asia/Jakarta');
$hari_ini = date('Y-m-d');

// --- DATA RINGKASAN ---
// A. Omzet Hari Ini
$q_omzet = mysqli_query($koneksi, "SELECT SUM(total_bayar) as total FROM transactions WHERE DATE(tanggal_buat) = '$hari_ini' AND status='paid'");
$d_omzet = mysqli_fetch_assoc($q_omzet);
$omzet_hari_ini = $d_omzet['total'] ?: 0;

// B. Transaksi Hari Ini
$q_trx = mysqli_query($koneksi, "SELECT COUNT(*) as jml FROM transactions WHERE DATE(tanggal_buat) = '$hari_ini'");
$d_trx = mysqli_fetch_assoc($q_trx);
$trx_hari_ini = $d_trx['jml'] ?: 0;

// C. Omzet Minggu Ini
$monday = date('Y-m-d', strtotime('monday this week'));
$sunday = date('Y-m-d', strtotime('sunday this week'));
$q_weekly = mysqli_query($koneksi, "SELECT SUM(total_bayar) as total FROM transactions WHERE DATE(tanggal_buat) BETWEEN '$monday' AND '$sunday' AND status='paid'");
$d_weekly = mysqli_fetch_assoc($q_weekly);
$omzet_minggu_ini = $d_weekly['total'] ?: 0;

// D. Stok Kritis
$q_stok = mysqli_query($koneksi, "SELECT COUNT(*) as jml FROM raw_materials WHERE stok <= 5");
$d_stok = mysqli_fetch_assoc($q_stok);
$stok_kritis = $d_stok['jml'] ?: 0;

// --- DATA GRAFIK ---
$labels = [];
$totals = [];
$q_chart = mysqli_query($koneksi, "
    SELECT DATE(tanggal_buat) as tgl, SUM(total_bayar) as omzet 
    FROM transactions 
    WHERE status='paid' 
    GROUP BY DATE(tanggal_buat) 
    ORDER BY tgl DESC LIMIT 7
");

while($row = mysqli_fetch_assoc($q_chart)){
    $labels[] = date('d M', strtotime($row['tgl']));
    $totals[] = (int)$row['omzet'];
}
$labels = array_reverse($labels);
$totals = array_reverse($totals);
$json_labels = json_encode($labels);
$json_totals = json_encode($totals);

// INCLUDE SIDEBAR DI SINI (Setelah logika PHP selesai)
include 'sidebar.php'; 
?>

<style>
    /* Card Stats Modern */
    .stat-card {
        transition: all 0.3s ease;
        border: none;
        border-radius: 12px;
        background: #fff;
        box-shadow: 0 2px 6px rgba(0,0,0,0.02);
        overflow: hidden;
        position: relative;
    }
    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0,0,0,0.08);
    }
    
    /* Icon Box dengan Warna Soft */
    .icon-box-shape {
        width: 50px; height: 50px;
        border-radius: 12px;
        display: flex; align-items: center; justify-content: center;
        font-size: 1.4rem;
        margin-bottom: 12px;
    }
    .bg-soft-primary { background: rgba(59, 130, 246, 0.1); color: #3b82f6; }
    .bg-soft-success { background: rgba(16, 185, 129, 0.1); color: #10b981; }
    .bg-soft-info    { background: rgba(14, 165, 233, 0.1); color: #0ea5e9; }
    .bg-soft-danger  { background: rgba(239, 68, 68, 0.1);  color: #ef4444; }

    /* Typography */
    .stat-label { font-size: 0.8rem; font-weight: 600; text-transform: uppercase; color: #94a3b8; letter-spacing: 0.5px; }
    .stat-value { font-size: 1.5rem; font-weight: 700; color: #1e293b; letter-spacing: -0.5px; }

    /* Tombol Akses Cepat */
    .quick-link {
        display: flex; align-items: center;
        padding: 16px;
        background: #fff;
        border: 1px solid #f1f5f9;
        border-radius: 12px;
        text-decoration: none;
        color: #334155;
        transition: all 0.2s;
    }
    .quick-link:hover {
        background: #f8fafc;
        border-color: #3b82f6;
        transform: translateX(5px);
    }
    .quick-link-icon {
        width: 40px; height: 40px;
        border-radius: 8px;
        background: #eff6ff; color: #3b82f6;
        display: flex; align-items: center; justify-content: center;
        margin-right: 15px; font-size: 1.1rem;
    }

    /* Tabel & List */
    .table-custom thead th {
        font-size: 0.75rem;
        text-transform: uppercase;
        color: #64748b;
        background: #f8fafc;
        border-bottom: 1px solid #e2e8f0;
        padding-top: 12px; padding-bottom: 12px;
    }
    .badge-modern { padding: 5px 10px; border-radius: 6px; font-size: 0.7rem; font-weight: 600; letter-spacing: 0.5px; }
</style>

<div class="d-flex justify-content-between align-items-end mb-4">
    <div>
        <h3 class="fw-bold text-dark mb-1" style="letter-spacing: -0.5px;">Dashboard</h3>
        <p class="text-muted mb-0 small">Ringkasan performa restoran hari ini, <span class="fw-bold text-dark"><?= date('d F Y'); ?></span></p>
    </div>
    <button onclick="window.location.reload()" class="btn btn-white bg-white border shadow-sm btn-sm fw-bold px-3 py-2" style="border-radius: 8px;">
        <i class="fas fa-sync-alt me-2 text-primary"></i> Refresh Data
    </button>
</div>

<div class="row g-4 mb-4">
    <div class="col-xl-3 col-md-6">
        <div class="stat-card p-4 h-100">
            <div class="d-flex justify-content-between">
                <div>
                    <div class="stat-label mb-1">Omzet Hari Ini</div>
                    <div class="stat-value">Rp <?php echo number_format($omzet_hari_ini, 0, ',', '.'); ?></div>
                    <div class="mt-2 small text-success fw-bold"><i class="fas fa-arrow-up me-1"></i> Update Live</div>
                </div>
                <div class="icon-box-shape bg-soft-primary">
                    <i class="fas fa-wallet"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6">
        <div class="stat-card p-4 h-100">
            <div class="d-flex justify-content-between">
                <div>
                    <div class="stat-label mb-1">Total Bon</div>
                    <div class="stat-value"><?php echo $trx_hari_ini; ?> <span class="fs-6 text-muted fw-normal">Trx</span></div>
                    <div class="mt-2 small text-muted">Transaksi sukses</div>
                </div>
                <div class="icon-box-shape bg-soft-success">
                    <i class="fas fa-receipt"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6">
        <div class="stat-card p-4 h-100">
            <div class="d-flex justify-content-between">
                <div>
                    <div class="stat-label mb-1">Omzet Minggu Ini</div>
                    <div class="stat-value" style="font-size: 1.3rem;">Rp <?php echo number_format($omzet_minggu_ini, 0, ',', '.'); ?></div>
                    <div class="mt-2 small text-muted">Senin - Minggu</div>
                </div>
                <div class="icon-box-shape bg-soft-info">
                    <i class="fas fa-calendar-week"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6">
        <div class="stat-card p-4 h-100" style="<?php echo ($stok_kritis > 0) ? 'border-left: 4px solid #ef4444;' : ''; ?>">
            <div class="d-flex justify-content-between">
                <div>
                    <div class="stat-label mb-1 text-danger">Stok Menipis</div>
                    <div class="stat-value text-danger"><?php echo $stok_kritis; ?> <span class="fs-6 text-muted fw-normal">Item</span></div>
                    <div class="mt-2 small text-muted">Perlu belanja</div>
                </div>
                <div class="icon-box-shape bg-soft-danger">
                    <i class="fas fa-exclamation-triangle"></i>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row g-4">
    
    <div class="col-lg-8">
        <div class="card border-0 shadow-sm h-100" style="border-radius: 12px;">
            <div class="card-header bg-white py-3 border-bottom border-light d-flex justify-content-between align-items-center" style="border-radius: 12px 12px 0 0;">
                <h6 class="fw-bold mb-0 text-dark">Tren Penjualan (7 Hari)</h6>
                <i class="fas fa-chart-line text-muted"></i>
            </div>
            <div class="card-body">
                <canvas id="salesChart" style="height: 350px; width: 100%;"></canvas>
            </div>
        </div>
    </div>

    <div class="col-lg-4">
        
        <div class="card border-0 shadow-sm mb-4" style="border-radius: 12px;">
            <div class="card-header bg-white py-3 border-bottom border-light" style="border-radius: 12px 12px 0 0;">
                <h6 class="fw-bold mb-0 text-dark">Akses Cepat</h6>
            </div>
            <div class="card-body p-3">
                <div class="d-flex flex-column gap-2">
                    <a href="kasir.php" class="quick-link">
                        <div class="quick-link-icon"><i class="fas fa-cash-register"></i></div>
                        <div>
                            <div class="fw-bold">Mesin Kasir</div>
                            <small class="text-muted">Input pesanan baru</small>
                        </div>
                    </a>
                    <a href="admin_menu.php" class="quick-link">
                        <div class="quick-link-icon" style="background: #ecfdf5; color: #10b981;"><i class="fas fa-utensils"></i></div>
                        <div>
                            <div class="fw-bold">Manajemen Menu</div>
                            <small class="text-muted">Tambah/Edit produk</small>
                        </div>
                    </a>
                    <a href="laporan.php" class="quick-link">
                        <div class="quick-link-icon" style="background: #fffbeb; color: #f59e0b;"><i class="fas fa-file-invoice-dollar"></i></div>
                        <div>
                            <div class="fw-bold">Laporan Keuangan</div>
                            <small class="text-muted">Lihat detail profit</small>
                        </div>
                    </a>
                </div>
            </div>
        </div>

        <div class="card border-0 shadow-sm" style="border-radius: 12px;">
            <div class="card-header bg-white py-3 border-bottom border-light d-flex justify-content-between align-items-center" style="border-radius: 12px 12px 0 0;">
                <h6 class="fw-bold mb-0 text-dark">Menu Terlaris</h6>
                <span class="badge bg-primary rounded-pill">Top 5</span>
            </div>
            <ul class="list-group list-group-flush">
                <?php
                $q_top = mysqli_query($koneksi, "
                    SELECT ti.nama_produk_snapshot as nama, SUM(ti.qty) as total
                    FROM transaction_items ti
                    JOIN transactions t ON ti.transaction_id = t.id
                    WHERE t.status = 'paid'
                    GROUP BY ti.product_id
                    ORDER BY total DESC LIMIT 5
                ");

                $rank = 1;
                if(mysqli_num_rows($q_top) > 0){
                    while($row = mysqli_fetch_assoc($q_top)){
                        // Icon Mahkota
                        if($rank == 1) $icon = "<span class='text-warning'><i class='fas fa-crown'></i></span>";
                        elseif($rank == 2) $icon = "<span class='text-secondary'><i class='fas fa-medal'></i></span>";
                        elseif($rank == 3) $icon = "<span class='text-danger'><i class='fas fa-medal'></i></span>";
                        else $icon = "<span class='text-muted fw-bold small'>#$rank</span>";

                        echo '
                        <li class="list-group-item d-flex justify-content-between align-items-center py-3 border-bottom-light">
                            <div class="d-flex align-items-center">
                                <div class="me-3 text-center" style="width:25px;">'.$icon.'</div>
                                <div>
                                    <div class="fw-bold text-dark text-capitalize" style="font-size:0.9rem;">'.$row['nama'].'</div>
                                    <small class="text-muted">Terjual '.$row['total'].' porsi</small>
                                </div>
                            </div>
                        </li>';
                        $rank++;
                    }
                } else {
                    echo '<li class="list-group-item text-center py-4 text-muted small">Belum ada data penjualan.</li>';
                }
                ?>
            </ul>
        </div>

    </div>
</div>

<div class="row mt-4 mb-5">
    <div class="col-12">
        <div class="card border-0 shadow-sm" style="border-radius: 12px;">
            <div class="card-header bg-white py-3 border-bottom border-light" style="border-radius: 12px 12px 0 0;">
                <h6 class="fw-bold mb-0 text-danger"><i class="fas fa-bell me-2"></i> Peringatan Stok Bahan Baku</h6>
            </div>
            <div class="table-responsive">
                <table class="table table-custom align-middle mb-0 table-hover">
                    <thead>
                        <tr>
                            <th class="ps-4">Nama Bahan</th>
                            <th>Satuan</th>
                            <th class="text-center">Sisa Stok</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $q_stok_low = mysqli_query($koneksi, "SELECT * FROM raw_materials ORDER BY stok ASC LIMIT 5");
                        
                        if(mysqli_num_rows($q_stok_low) > 0){
                            while($row = mysqli_fetch_assoc($q_stok_low)){
                                $stok = $row['stok'];
                                if($stok <= 5) {
                                    $badge = "<span class='badge-modern bg-danger bg-opacity-10 text-danger'>KRITIS</span>";
                                    $warna_stok = "text-danger fw-bold";
                                } elseif($stok <= 10) {
                                    $badge = "<span class='badge-modern bg-warning bg-opacity-10 text-warning'>MENIPIS</span>";
                                    $warna_stok = "text-warning fw-bold";
                                } else {
                                    $badge = "<span class='badge-modern bg-success bg-opacity-10 text-success'>AMAN</span>";
                                    $warna_stok = "text-success fw-bold";
                                }

                                echo "<tr>";
                                echo "<td class='ps-4 fw-600 text-dark'>{$row['nama_bahan']}</td>";
                                echo "<td class='text-muted'>{$row['satuan']}</td>";
                                echo "<td class='text-center $warna_stok'>{$row['stok']}</td>";
                                echo "<td>$badge</td>";
                                echo "</tr>";
                            }
                        } else {
                            echo "<tr><td colspan='4' class='text-center py-4 text-muted small'>Semua stok aman terkendali.</td></tr>";
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Konfigurasi Grafik Modern
    const ctx = document.getElementById('salesChart').getContext('2d');
    const labels = <?php echo $json_labels; ?>;
    const dataOmzet = <?php echo $json_totals; ?>;

    // Gradient Cantik ala Sidebar
    let gradient = ctx.createLinearGradient(0, 0, 0, 400);
    gradient.addColorStop(0, 'rgba(59, 130, 246, 0.5)'); // Sesuaikan warna primary sidebar
    gradient.addColorStop(1, 'rgba(59, 130, 246, 0.0)'); 

    new Chart(ctx, {
        type: 'line', 
        data: {
            labels: labels,
            datasets: [{
                label: 'Omzet (Rp)',
                data: dataOmzet,
                borderColor: '#3b82f6', 
                backgroundColor: gradient, 
                borderWidth: 3,
                pointBackgroundColor: '#fff',
                pointBorderColor: '#3b82f6',
                pointRadius: 5,
                pointHoverRadius: 7,
                fill: true, 
                tension: 0.4 
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: { display: false }, 
                tooltip: {
                    backgroundColor: '#1e293b', // Dark sidebar color
                    titleFont: { family: 'Inter', size: 13 },
                    bodyFont: { family: 'Inter', size: 13, weight: 'bold' },
                    padding: 12,
                    cornerRadius: 8,
                    displayColors: false,
                    callbacks: {
                        label: function(context) {
                            let label = context.dataset.label || '';
                            if (label) { label += ': '; }
                            if (context.parsed.y !== null) {
                                label += new Intl.NumberFormat('id-ID', { style: 'currency', currency: 'IDR' }).format(context.parsed.y);
                            }
                            return label;
                        }
                    }
                }
            },
            scales: {
                y: { 
                    beginAtZero: true, 
                    grid: { borderDash: [5, 5], color: '#f1f5f9' },
                    ticks: { font: { family: 'Inter', size: 11 }, color: '#94a3b8' }
                },
                x: { 
                    grid: { display: false },
                    ticks: { font: { family: 'Inter', size: 11 }, color: '#94a3b8' }
                }
            }
        }
    });
</script>

<?php include 'footer.php'; ?>