<?php
include 'koneksi.php';

$start = isset($_GET['start']) ? $_GET['start'] : date('Y-m-01');
$end   = isset($_GET['end']) ? $_GET['end'] : date('Y-m-d');

// Setting Header agar Browser mendeteksi ini sebagai file Excel
header("Content-type: application/vnd-ms-excel");
header("Content-Disposition: attachment; filename=Laporan_Penjualan_$start-sd-$end.xls");

$start_time = $start . " 00:00:00";
$end_time   = $end . " 23:59:59";

$sql = "SELECT t.*, 
        GROUP_CONCAT(CONCAT(ti.qty, 'x ', ti.nama_produk_snapshot) SEPARATOR ', ') as detail_items 
        FROM transactions t
        LEFT JOIN transaction_items ti ON t.id = ti.transaction_id
        WHERE t.tanggal_buat BETWEEN '$start_time' AND '$end_time'
        GROUP BY t.id
        ORDER BY t.tanggal_buat DESC";

$query = mysqli_query($koneksi, $sql);
?>

<center>
    <h3>LAPORAN PENJUALAN RESTORAN</h3>
    <p>Periode: <?= $start; ?> s/d <?= $end; ?></p>
</center>

<table border="1" width="100%">
    <thead>
        <tr style="background-color: #f2f2f2;">
            <th>No</th>
            <th>Tanggal & Waktu</th>
            <th>No Bon</th>
            <th>Nomor Pager</th>
            <th>Rincian Menu</th>
            <th>Total Bayar</th>
            <th>Metode Bayar</th>
            <th>Status</th>
        </tr>
    </thead>
    <tbody>
        <?php 
        $no = 1;
        $total_semua = 0;
        while($row = mysqli_fetch_assoc($query)): 
            $total_semua += $row['total_bayar'];
        ?>
        <tr>
            <td align="center"><?= $no++; ?></td>
            <td align="center"><?= $row['tanggal_buat']; ?></td>
            <td><?= $row['kode_transaksi']; ?></td>
            <td align="center"><?= $row['nomor_pager']; ?></td>
            <td><?= $row['detail_items']; ?></td>
            <td align="right"><?= $row['total_bayar']; ?></td>
            <td align="center"><?= $row['metode_bayar']; ?></td>
            <td align="center"><?= $row['status']; ?></td>
        </tr>
        <?php endwhile; ?>
    </tbody>
    <tfoot>
        <tr style="background-color: #ffffcc; font-weight: bold;">
            <td colspan="5" align="right">TOTAL OMZET</td>
            <td align="right"><?= $total_semua; ?></td>
            <td colspan="2"></td>
        </tr>
    </tfoot>
</table>