<?php
include 'koneksi.php';

// Ambil data filter dari URL
$tgl_awal  = isset($_GET['tgl_awal']) ? $_GET['tgl_awal'] : '';
$tgl_akhir = isset($_GET['tgl_akhir']) ? $_GET['tgl_akhir'] : '';

// Siapkan Query
$where = "";
if(!empty($tgl_awal) && !empty($tgl_akhir)){
    $where = "WHERE DATE(tanggal) BETWEEN '$tgl_awal' AND '$tgl_akhir'";
    $filename = "Laporan_Pengeluaran_$tgl_awal-sd-$tgl_akhir.xls";
} else {
    $filename = "Laporan_Semua_Pengeluaran.xls";
}

// Header agar dibaca sebagai file Excel
header("Content-type: application/vnd-ms-excel");
header("Content-Disposition: attachment; filename=$filename");
?>

<center>
    <h3>Data Pengeluaran Resto</h3>
    <?php if(!empty($tgl_awal)) { echo "<p>Periode: $tgl_awal s/d $tgl_akhir</p>"; } ?>
</center>

<table border="1" cellpadding="5" cellspacing="0" width="100%">
    <thead>
        <tr style="background-color: #f2f2f2;">
            <th>No</th>
            <th>Tanggal & Jam</th>
            <th>Deskripsi</th>
            <th>Kategori</th>
            <th>Nominal</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $no = 1;
        $total = 0;
        $query = mysqli_query($koneksi, "SELECT * FROM expenses $where ORDER BY tanggal DESC");
        
        while($row = mysqli_fetch_assoc($query)){
            $total += $row['nominal'];
        ?>
        <tr>
            <td align="center"><?= $no++; ?></td>
            <td><?= date('d/m/Y H:i', strtotime($row['tanggal'])); ?></td>
            <td><?= $row['deskripsi']; ?></td>
            <td><?= $row['kategori']; ?></td>
            <td align="right">Rp <?= number_format($row['nominal'], 0, ',', '.'); ?></td>
        </tr>
        <?php } ?>
        <tr style="font-weight: bold; background-color: #e6e6e6;">
            <td colspan="4" align="center">TOTAL PENGELUARAN</td>
            <td align="right">Rp <?= number_format($total, 0, ',', '.'); ?></td>
        </tr>
    </tbody>
</table>