<?php
error_reporting(0);
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

// Cek lokasi koneksi (Smart Check)
if (file_exists('../koneksi.php')) { include '../koneksi.php'; } 
elseif (file_exists('koneksi.php')) { include 'koneksi.php'; } 
else { echo json_encode(["error" => "Koneksi hilang"]); exit(); }

date_default_timezone_set('Asia/Jakarta');

// Query: Ambil data 7 hari terakhir, Grouping per Tanggal
// Kita bersihkan dulu format uangnya (REPLACE titik/koma) jaga-jaga kalau formatnya string
$query = "SELECT 
            DATE(tanggal_buat) as tgl,
            SUM(CAST(REPLACE(REPLACE(REPLACE(total_bayar, 'Rp', ''), '.', ''), ',', '') AS UNSIGNED)) as total_omzet
          FROM transactions 
          WHERE tanggal_buat >= DATE_SUB(CURDATE(), INTERVAL 6 DAY)
          GROUP BY DATE(tanggal_buat)
          ORDER BY tgl ASC";

$result = mysqli_query($koneksi, $query);

$labels = [];
$data   = [];

while($row = mysqli_fetch_assoc($result)) {
    // Ubah format tgl jadi lebih cantik (misal: 26 Dec)
    $tgl_cantik = date('d M', strtotime($row['tgl']));
    
    $labels[] = $tgl_cantik;
    $data[]   = $row['total_omzet'];
}

echo json_encode([
    "labels" => $labels,
    "data"   => $data
]);
?>