<?php
// File: api_kasir/get_dapur.php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header("Cache-Control: no-cache, no-store, must-revalidate");

// Matikan error display agar tidak merusak format JSON
error_reporting(0); 
ini_set('display_errors', 0);

include 'koneksi.php'; 
if (!isset($koneksi)) { if(isset($conn)) $koneksi = $conn; }

date_default_timezone_set('Asia/Jakarta');

// 1. Ambil Transaksi Pending
$query = mysqli_query($koneksi, "SELECT * FROM transactions WHERE status_dapur = 'pending' ORDER BY id ASC");

$result = [];

if($query){
    while($trx = mysqli_fetch_assoc($query)){
        $trx_id = $trx['id'];
        
        // 2. Ambil Item
        $sql_item = "SELECT * FROM transaction_items WHERE transaction_id = '$trx_id'";
        $query_item = mysqli_query($koneksi, $sql_item);
        
        // Fallback jika nama kolom beda
        if(!$query_item){
            $sql_item = "SELECT * FROM transaction_items WHERE id_transaksi = '$trx_id'";
            $query_item = mysqli_query($koneksi, $sql_item);
        }

        $items = [];
        if($query_item){
            while($it = mysqli_fetch_assoc($query_item)){
                // Deteksi nama kolom produk
                $nama_produk = 'Produk ?';
                if(isset($it['nama_produk_snapshot'])) $nama_produk = $it['nama_produk_snapshot'];
                elseif(isset($it['nama_produk'])) $nama_produk = $it['nama_produk'];
                elseif(isset($it['nama'])) $nama_produk = $it['nama'];

                $items[] = [
                    'qty'  => $it['qty'],
                    'nama' => $nama_produk
                ];
            }
        }

        $trx['pesanan'] = $items;
        
        // Hitung Durasi (Menit)
        $waktu_pesan = strtotime($trx['tanggal_buat']);
        $menit = floor((time() - $waktu_pesan) / 60);
        if($menit < 0) $menit = 0; // Hindari minus
        $trx['durasi_menit'] = $menit;

        $result[] = $trx;
    }
}

echo json_encode($result);
?>