<?php
include 'koneksi.php';
header('Content-Type: application/json');
date_default_timezone_set('Asia/Jakarta'); 

$today = date('Y-m-d');

// 1. STATISTIK HARI INI
$q_omzet = mysqli_query($koneksi, "SELECT SUM(total_bayar) as total, COUNT(*) as jumlah FROM transactions WHERE DATE(tanggal_buat) = '$today' AND status='paid'");
$d_omzet = mysqli_fetch_assoc($q_omzet);

// --- HITUNG SALDO UNTUK DASHBOARD ---
// Laci
$q_laci_masuk = mysqli_query($koneksi, "SELECT SUM(total_bayar) as total FROM transactions WHERE DATE(tanggal_buat) = '$today' AND status='paid' AND (metode_bayar = 'cash' OR metode_bayar IS NULL)");
$d_laci_masuk = mysqli_fetch_assoc($q_laci_masuk);
$q_laci_keluar = mysqli_query($koneksi, "SELECT SUM(nominal) as total FROM expenses WHERE DATE(tanggal) = '$today' AND sumber_dana = 'laci'");
$d_laci_keluar = mysqli_fetch_assoc($q_laci_keluar);
$q_laci_setor = mysqli_query($koneksi, "SELECT SUM(nominal) as total FROM cash_flows WHERE jenis='setor_bank' AND DATE(tanggal) = '$today'");
$d_laci_setor = mysqli_fetch_assoc($q_laci_setor);
$saldo_laci = ($d_laci_masuk['total'] ?? 0) - ($d_laci_keluar['total'] ?? 0) - ($d_laci_setor['total'] ?? 0);

// Bank (Total Asset)
$q_bank_jual = mysqli_query($koneksi, "SELECT SUM(total_bayar) as total FROM transactions WHERE status='paid' AND metode_bayar != 'cash' AND metode_bayar IS NOT NULL");
$d_bank_jual = mysqli_fetch_assoc($q_bank_jual);
$q_bank_setor_masuk = mysqli_query($koneksi, "SELECT SUM(nominal) as total FROM cash_flows WHERE jenis='setor_bank'");
$d_bank_setor_masuk = mysqli_fetch_assoc($q_bank_setor_masuk);
$q_bank_keluar = mysqli_query($koneksi, "SELECT SUM(nominal) as total FROM expenses WHERE sumber_dana = 'bank'");
$d_bank_keluar = mysqli_fetch_assoc($q_bank_keluar);
$saldo_bank = (($d_bank_jual['total'] ?? 0) + ($d_bank_setor_masuk['total'] ?? 0)) - ($d_bank_keluar['total'] ?? 0);
// ------------------------------------

// 2. CEK STOK MENIPIS
$q_stok = mysqli_query($koneksi, "SELECT COUNT(*) as jumlah FROM products WHERE stok < 5 AND is_active=1");
$d_stok = mysqli_fetch_assoc($q_stok);

// 3. GRAFIK 7 HARI TERAKHIR
$chart_labels = [];
$chart_data = [];
for ($i = 6; $i >= 0; $i--) {
    $tgl = date('Y-m-d', strtotime("-$i days"));
    $q_chart = mysqli_query($koneksi, "SELECT SUM(total_bayar) as total FROM transactions WHERE DATE(tanggal_buat) = '$tgl' AND status='paid'");
    $d_chart = mysqli_fetch_assoc($q_chart);
    
    $chart_labels[] = date('d M', strtotime($tgl)); 
    $chart_data[] = $d_chart['total'] ?? 0;
}

// 4. TOP 5 PRODUK
$q_top = mysqli_query($koneksi, "SELECT nama_produk_snapshot, SUM(qty) as total_qty FROM transaction_items GROUP BY product_id ORDER BY total_qty DESC LIMIT 5");
$top_products = [];
while($row = mysqli_fetch_assoc($q_top)){ $top_products[] = $row; }

// 5. TRANSAKSI TERBARU
$q_recent = mysqli_query($koneksi, "SELECT * FROM transactions ORDER BY tanggal_buat DESC LIMIT 5");
$recent_trx = [];
while($row = mysqli_fetch_assoc($q_recent)){ $recent_trx[] = $row; }

$response = [
    "omzet_hari_ini" => $d_omzet['total'] ?? 0,
    "trx_hari_ini" => $d_omzet['jumlah'] ?? 0,
    "saldo_laci" => $saldo_laci,   // Data Baru
    "saldo_bank" => $saldo_bank,   // Data Baru
    "stok_tipis" => $d_stok['jumlah'] ?? 0,
    "chart" => [ "labels" => $chart_labels, "data" => $chart_data ],
    "top_products" => $top_products,
    "recent" => $recent_trx
];

echo json_encode($response);
?>