<?php
error_reporting(0);
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

// --- GUNAKAN LOGIKA KONEKSI YANG SUDAH TERBUKTI BERHASIL ---
if (file_exists('../koneksi.php')) {
    include '../koneksi.php';
} elseif (file_exists('koneksi.php')) {
    include 'koneksi.php';
} else {
    echo json_encode(["error" => "Koneksi hilang"]);
    exit();
}

date_default_timezone_set('Asia/Jakarta');
$hari_ini = date('Y-m-d'); // Tanggal versi PHP (WIB)

// =======================================================
// 1. QUERY OMZET "ANTI-GAGAL"
// =======================================================
// Trik 1: REPLACE(...) membuang "Rp", titik, dan koma agar jadi angka murni
// Trik 2: WHERE ... OR ... mengecek tanggal versi WIB atau versi Server (CURDATE)

$sql_stats = "SELECT 
                SUM(CAST(
                    REPLACE(REPLACE(REPLACE(total_bayar, 'Rp', ''), '.', ''), ',', '') 
                AS UNSIGNED)) as total, 
                COUNT(*) as jumlah 
              FROM transactions 
              WHERE tanggal_buat LIKE '$hari_ini%' 
                 OR DATE(tanggal_buat) = CURDATE()"; 

$query_stats = mysqli_query($koneksi, $sql_stats);
$data_stats  = mysqli_fetch_assoc($query_stats);

$omzet_fix  = ($data_stats['total'] === null) ? 0 : $data_stats['total'];
$jumlah_fix = ($data_stats['jumlah'] === null) ? 0 : $data_stats['jumlah'];


// =======================================================
// 2. QUERY RIWAYAT (TETAP SEPERTI SEBELUMNYA)
// =======================================================
$sql_list = "SELECT * FROM transactions ORDER BY id DESC LIMIT 50";
$query_list = mysqli_query($koneksi, $sql_list);
$list_transaksi = [];

if ($query_list) {
    while($row = mysqli_fetch_assoc($query_list)){
        $list_transaksi[] = $row;
    }
}

// =======================================================
// 3. KIRIM HASIL
// =======================================================
echo json_encode([
    "stats" => [
        "omzet_hari_ini"     => (int)$omzet_fix,
        "transaksi_hari_ini" => (int)$jumlah_fix
    ],
    "riwayat" => $list_transaksi
]);
?>