<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
include 'koneksi.php';

$start = isset($_GET['start']) ? $_GET['start'] : date('Y-m-01');
$end   = isset($_GET['end']) ? $_GET['end'] : date('Y-m-d');

// Tambahkan waktu agar mencakup seluruh hari terakhir (sampai jam 23:59:59)
$start_time = $start . " 00:00:00";
$end_time   = $end . " 23:59:59";

// 1. Ambil Summary
$q_sum = mysqli_query($koneksi, "SELECT SUM(total_bayar) as omzet, COUNT(*) as jml FROM transactions WHERE status = 'paid' AND (tanggal_buat BETWEEN '$start_time' AND '$end_time')");
$d_sum = mysqli_fetch_assoc($q_sum);

// 2. Ambil List Transaksi dengan Detail Item (GROUP_CONCAT)
// Menggabungkan nama produk dan qty menjadi string: "2x Nasi Goreng, 1x Es Teh"
$sql = "SELECT t.*, 
        GROUP_CONCAT(CONCAT(ti.qty, 'x ', ti.nama_produk_snapshot) SEPARATOR ', ') as detail_items 
        FROM transactions t
        LEFT JOIN transaction_items ti ON t.id = ti.transaction_id
        WHERE t.tanggal_buat BETWEEN '$start_time' AND '$end_time'
        GROUP BY t.id
        ORDER BY t.tanggal_buat DESC";

$q_trx = mysqli_query($koneksi, $sql);
$data_trx = [];

while($row = mysqli_fetch_assoc($q_trx)) {
    $data_trx[] = $row;
}

echo json_encode([
    "summary" => [
        "total_omzet" => $d_sum['omzet'] ?? 0,
        "jumlah_transaksi" => $d_sum['jml'] ?? 0
    ],
    "transaksi" => $data_trx
]);
?>