<?php
session_start();
if(!isset($_SESSION['status']) || $_SESSION['status'] != "sudah_login"){ 
    header("location:login.php"); 
    exit(); 
}
$isAdmin = ($_SESSION['role'] == 'admin');

include 'koneksi.php';

// Ambil Settings
$q_toko = mysqli_query($koneksi, "SELECT * FROM settings LIMIT 1");
$d_toko = mysqli_fetch_assoc($q_toko);
$nama_toko = $d_toko['nama_toko'] ?? 'POS SYSTEM';
$logo_toko = $d_toko['logo'] ?? '';
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Kasir - <?= $nama_toko; ?></title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://unpkg.com/html5-qrcode" type="text/javascript"></script>

    <style>
        :root {
            /* Palette Profesional */
            --primary: #3b82f6; 
            --primary-dark: #2563eb;
            --accent: #10b981; /* Emerald Green untuk uang/sukses */
            --bg-body: #f8fafc; /* Slate very light */
            --card-bg: #ffffff;
            --text-main: #1e293b; 
            --text-muted: #64748b;
            --border-color: #e2e8f0;
            --radius-md: 16px; 
            --radius-sm: 10px;
            --shadow-soft: 0 4px 20px -2px rgba(0,0,0,0.05);
            --shadow-hover: 0 10px 25px -5px rgba(0,0,0,0.1);
        }

        body { 
            background-color: var(--bg-body); 
            font-family: 'Inter', sans-serif; 
            color: var(--text-main); 
            overflow: hidden; 
        }
        
        /* --- NAVBAR GLASSMORPHISM --- */
        .navbar-kasir {
            background: rgba(255, 255, 255, 0.85); 
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
            padding: 0 20px; 
            height: 65px; 
            border-bottom: 1px solid rgba(226, 232, 240, 0.8);
            display: flex; justify-content: space-between; align-items: center;
            position: fixed; top: 0; left: 0; right: 0; z-index: 1030;
            box-shadow: 0 1px 2px rgba(0,0,0,0.03);
        }
        .brand-logo { height: 32px; width: auto; object-fit: contain; margin-right: 12px; }
        .brand-text { font-weight: 800; font-size: 16px; color: #0f172a; letter-spacing: -0.5px; text-transform: uppercase; }

        /* --- BUTTONS --- */
        .btn-icon-nav {
            width: 40px; height: 40px; border-radius: 10px; 
            display: flex; align-items: center; justify-content: center;
            border: 1px solid transparent; background: #f1f5f9;
            color: var(--text-muted); transition: all 0.2s;
        }
        .btn-icon-nav:hover { background: #e2e8f0; color: var(--primary); transform: translateY(-2px); }
        
        /* --- LAYOUT --- */
        .kasir-wrapper { 
            padding: 15px; 
            margin-top: 65px; 
            height: calc(100vh - 65px); 
            box-sizing: border-box; 
        }
        .kasir-container { display: flex; gap: 20px; height: 100%; }
        
        /* KOLOM KIRI (MENU) */
        .col-kiri { 
            flex: 3; display: flex; flex-direction: column; 
            background: var(--bg-body); /* Transparan agar menyatu */
            overflow: hidden; 
            border-radius: var(--radius-md);
        }
        
        /* KOLOM KANAN (CART) */
        .col-kanan { 
            flex: 1.2; min-width: 380px; display: flex; flex-direction: column;
            background: var(--card-bg); 
            border-radius: var(--radius-md); 
            box-shadow: var(--shadow-soft);
            border: 1px solid var(--border-color);
            overflow: hidden; position: relative;
        }

        /* --- TABS --- */
        .tab-wrapper { background: transparent; padding-bottom: 15px; display: flex; gap: 10px; }
        .btn-tab { 
            flex: 1; padding: 12px; border: none; background: #ffffff; 
            border-radius: var(--radius-md); font-weight: 700; color: var(--text-muted); cursor: pointer;
            display: flex; align-items: center; justify-content: center; gap: 8px; font-size: 13px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.03); transition: all 0.2s;
            border: 1px solid transparent;
        }
        .btn-tab:hover { transform: translateY(-2px); color: var(--primary); }
        .btn-tab.active { 
            background: var(--primary); color: white; 
            box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
        }
        
        .tab-content { padding: 5px; overflow-y: auto; flex: 1; padding-bottom: 50px; scroll-behavior: smooth; }
        .tab-content::-webkit-scrollbar { width: 6px; }
        .tab-content::-webkit-scrollbar-thumb { background-color: #cbd5e1; border-radius: 20px; }

        /* --- SEARCH BOX --- */
        .search-wrapper { position: relative; margin-bottom: 15px; }
        .search-input { 
            width: 100%; padding: 14px 14px 14px 45px; 
            border-radius: 12px; border: none; 
            background: #ffffff; box-shadow: 0 2px 10px rgba(0,0,0,0.03);
            font-size: 14px; color: var(--text-main); transition: all 0.2s;
        }
        .search-input:focus { outline: none; box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1); }
        .search-icon { position: absolute; left: 18px; top: 15px; color: #94a3b8; font-size: 16px; }

        /* --- MENU CARDS (GRID) --- */
        .menu-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(140px, 1fr)); gap: 15px; }
        .menu-card { 
            background: #fff; border-radius: 16px; padding: 15px; 
            text-align: center; cursor: pointer; 
            border: 1px solid transparent; 
            box-shadow: 0 2px 8px rgba(0,0,0,0.02);
            transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
            display: flex; flex-direction: column; justify-content: space-between; height: 100%;
            position: relative; overflow: hidden;
        }
        .menu-card:hover { 
            transform: translateY(-5px); 
            box-shadow: var(--shadow-hover);
            border-color: rgba(59, 130, 246, 0.2);
        }
        .menu-card:active { transform: scale(0.96); }
        
        .menu-icon-wrapper {
            width: 50px; height: 50px; margin: 0 auto 12px;
            background: #f0f9ff; color: var(--primary);
            border-radius: 50%; display: flex; align-items: center; justify-content: center;
            font-size: 20px; transition: background 0.3s;
        }
        .menu-card:hover .menu-icon-wrapper { background: var(--primary); color: white; }

        .menu-nama { 
            font-weight: 600; font-size: 13px; margin-bottom: 8px; line-height: 1.3; 
            color: var(--text-main);
            display: -webkit-box; -webkit-line-clamp: 2; -webkit-box-orient: vertical; overflow: hidden;
        }
        .menu-harga { 
            color: var(--text-main); font-weight: 800; font-size: 14px; 
            background: #f8fafc; padding: 6px; border-radius: 8px;
        }

        /* --- CART DESIGN --- */
        .cart-header { 
            padding: 18px 20px; background: #fff; 
            border-bottom: 1px solid var(--border-color); 
            font-weight: 800; display:flex; justify-content:space-between; align-items:center; 
            font-size: 15px; letter-spacing: -0.3px;
        }
        .cart-body { flex: 1; overflow-y: auto; padding: 0; background: #ffffff; }
        
        .cart-item { 
            padding: 15px 20px; border-bottom: 1px solid #f1f5f9; 
            display: flex; align-items: center; justify-content: space-between; gap: 10px;
            transition: background 0.2s;
        }
        .cart-item:hover { background: #fafafa; }
        
        .cart-item-info { flex: 1; min-width: 0; } 
        .cart-item-name { 
            font-weight: 600; font-size: 14px; color: var(--text-main); margin-bottom: 3px;
            white-space: nowrap; overflow: hidden; text-overflow: ellipsis; 
        }
        .cart-item-price { font-size: 12px; color: var(--text-muted); font-weight: 500; }

        .cart-item-actions { display: flex; align-items: center; gap: 8px; flex-shrink: 0; }
        .btn-qty { 
            width: 28px; height: 28px; border-radius: 8px; border: 1px solid #e2e8f0; 
            background: #fff; color: var(--text-main); font-weight: bold; cursor: pointer; 
            font-size: 14px; display:flex; align-items:center; justify-content:center; transition:0.2s;
        }
        .btn-qty:hover { background: var(--primary); color: white; border-color: var(--primary); }
        .qty-val { font-size: 14px; font-weight: 700; width: 20px; text-align: center; }
        .subtotal-val { font-size: 14px; font-weight: 700; color: var(--text-main); width: 75px; text-align: right; }

        .cart-footer { 
            padding: 20px; background: #fff; border-top: 1px solid var(--border-color); 
            box-shadow: 0 -4px 20px rgba(0,0,0,0.02); z-index: 10;
        }
        
        .input-pager {
            background: #f8fafc; border: 1px solid #e2e8f0; border-radius: 10px; 
            font-weight: 700; text-align: center; color: var(--primary);
        }

        .btn-bayar { 
            background: linear-gradient(135deg, #10b981 0%, #059669 100%); 
            border: none; color: white; width: 100%; padding: 14px; 
            border-radius: 12px; font-weight: 700; font-size: 15px; 
            box-shadow: 0 4px 15px rgba(16, 185, 129, 0.3); transition: all 0.2s;
            letter-spacing: 0.5px;
        }
        .btn-bayar:hover { transform: translateY(-2px); box-shadow: 0 6px 20px rgba(16, 185, 129, 0.4); }
        .btn-bayar:active { transform: scale(0.98); }

        /* --- RESPONSIVE MOBILE --- */
        @media (max-width: 768px) {
            body { overflow-y: auto; background: #f1f5f9; }
            .navbar-kasir { padding: 0 15px; height: 60px; }
            .kasir-wrapper { padding: 10px; padding-bottom: 90px; margin-top: 60px; height: auto; }
            .kasir-container { display: block; }
            
            .col-kiri { 
                width: 100%; height: auto; min-height: 80vh; 
                box-shadow: none; border: none; background: transparent; overflow: visible; 
            }
            .tab-wrapper { position: sticky; top: 60px; z-index: 900; background: #f1f5f9; padding-top: 5px; margin: 0 -5px; padding-left: 5px; padding-right: 5px; }
            
            /* Panel Cart Slide Up */
            .col-kanan {
                position: fixed; bottom: -100%; left: 0; right: 0; 
                height: 85vh; width: 100%; z-index: 2050; 
                border-radius: 24px 24px 0 0; 
                box-shadow: 0 -10px 40px rgba(0,0,0,0.2);
                transition: bottom 0.35s cubic-bezier(0.32, 0.72, 0, 1);
            }
            .col-kanan.show { bottom: 0; }
            
            #mobile-overlay {
                display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%;
                background: rgba(15, 23, 42, 0.6); z-index: 2040; backdrop-filter: blur(4px);
            }

            .menu-grid { grid-template-columns: repeat(2, 1fr) !important; gap: 10px !important; }
            .menu-card { padding: 12px !important; }
            .menu-icon-wrapper { width: 40px; height: 40px; font-size: 18px; margin-bottom: 8px; }
        }

        /* MOBILE BOTTOM BAR */
        .mobile-cart-bar {
            display: none; position: fixed; bottom: 15px; left: 15px; right: 15px;
            background: #1e293b; color: white;
            padding: 12px 18px; border-radius: 16px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.4); z-index: 1045;
            align-items: center; justify-content: space-between;
            cursor: pointer; transition: transform 0.2s;
        }
        .mobile-cart-bar:active { transform: scale(0.97); }
        @media (max-width: 768px) { .mobile-cart-bar { display: flex; } }

        /* --- MODAL STYLE (FULL SCREEN ON MOBILE) --- */
        .modal-overlay { 
            display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; 
            background: rgba(15, 23, 42, 0.8); z-index: 9999; /* Z-Index tertinggi */
            backdrop-filter: blur(5px);
            justify-content: center; align-items: center; 
        }
        
        .modal-pay { 
            background: white; 
            width: 400px; 
            max-width: 100%; 
            border-radius: 20px; 
            box-shadow: 0 20px 60px rgba(0,0,0,0.3); 
            display: flex; flex-direction: column; 
            max-height: 90vh; /* Desktop: max 90% tinggi layar */
            overflow: hidden;
            animation: modalFadeIn 0.2s ease-out;
        }

        .modal-header-custom {
            padding: 20px;
            background: #fff;
            border-bottom: 1px solid #f1f5f9;
            display: flex; justify-content: space-between; align-items: center;
            flex-shrink: 0; /* Header tidak boleh mengecil */
        }

        .modal-pay-body { 
            padding: 20px;
            overflow-y: auto; /* Agar bisa discroll */
            flex: 1;
            background: #fff;
        }

        /* --- TAMPILAN KHUSUS HP (MOBILE FIX) --- */
        @media (max-width: 768px) {
            .modal-overlay {
                background: #fff; /* Background putih penuh di HP */
                align-items: flex-start; /* Mulai dari atas */
            }

            .modal-pay {
                width: 100%;
                height: 100%; /* Penuhi layar 100% */
                max-height: 100%; 
                border-radius: 0; /* Hilangkan lengkungan sudut */
                box-shadow: none;
                animation: none; /* Matikan animasi slide agar langsung muncul */
            }

            .modal-pay-body {
                padding-bottom: 150px; /* Jarak ekstra di bawah untuk keyboard HP */
            }
            
            /* Perbesar tombol close di HP agar mudah ditekan */
            .btn-close { padding: 15px; } 
        }

        @keyframes modalFadeIn { from { opacity: 0; transform: scale(0.95); } to { opacity: 1; transform: scale(1); } }

        /* Elemen Input & Tombol */
        .btn-cash { 
            padding: 12px 5px; background: #fff; border: 1px solid #cbd5e1; 
            border-radius: 10px; font-size:12px; font-weight:700; width: 100%; 
            color: var(--text-main); display: flex; align-items: center; justify-content: center;
        }
        .btn-cash:hover, .btn-cash:active { background: #e2e8f0; color: var(--primary); border-color: var(--primary); }
        
        .quick-cash-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 10px; margin-top: 15px; }
        
        .display-kembali { 
            font-size: 18px; font-weight: 800; text-align: center; margin-top: 20px; 
            padding: 15px; background: #ecfdf5; color: #047857; border-radius: 12px; border: 1px dashed #10b981; 
        }
    </style>
</head>
<body>

    <nav class="navbar-kasir">
        <div class="d-flex align-items-center" style="flex:1; min-width:0;">
            <?php if(!empty($logo_toko) && file_exists("api_kasir/images/".$logo_toko)){ ?>
                <img src="api_kasir/images/<?= $logo_toko; ?>" class="brand-logo" alt="Logo">
            <?php } else { ?>
                <div class="brand-logo d-flex align-items-center justify-content-center bg-primary bg-opacity-10 text-primary rounded-circle" style="width:32px;height:32px; flex-shrink:0;">
                    <i class="fas fa-store" style="font-size:14px;"></i>
                </div>
            <?php } ?>
            <div class="brand-text"><?= strtoupper($nama_toko); ?></div>
        </div>
        <div class="d-flex align-items-center gap-2">
            <button class="btn-icon-nav position-relative text-warning" data-bs-toggle="modal" data-bs-target="#modalSelesai">
                <i class="fas fa-bell"></i>
                <span id="badge-selesai" class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger border border-white" style="display:none; font-size:9px;">0</span>
            </button>
            <?php if($isAdmin){ ?> 
                <a href="dashboard.php" class="btn-icon-nav" title="Dashboard"><i class="fas fa-th-large"></i></a> 
            <?php } ?>
            <a href="logout.php" class="btn-icon-nav text-danger bg-danger bg-opacity-10" title="Logout"><i class="fas fa-power-off"></i></a>
        </div>
    </nav>

    <div id="mobile-overlay" onclick="toggleCart()"></div>

    <div class="kasir-wrapper">
        <div class="kasir-container">
            
            <div class="col-kiri">
                <div class="tab-wrapper">
                    <button class="btn-tab active" id="tab-btn-manual" onclick="switchTab('manual')">
                        <i class="fas fa-utensils"></i> MENU
                    </button>
                    <button class="btn-tab" id="tab-btn-scan" onclick="switchTab('scan')">
                        <i class="fas fa-qrcode"></i> SCAN
                    </button>
                </div>

                <div id="view-manual" class="tab-content">
                    <div class="search-wrapper">
                        <i class="fas fa-search search-icon"></i>
                        <input type="text" id="cari-menu" placeholder="Cari menu favorit..." onkeyup="filterMenu()" class="search-input">
                    </div>
                    <div class="menu-grid" id="daftar-menu-grid">
                        <div class="text-center mt-5 text-muted"><i class="fas fa-circle-notch fa-spin"></i> Loading...</div>
                    </div>
                </div>

                <div id="view-scan" class="tab-content" style="display:none; text-align:center; padding-top:40px;">
                    <div id="reader" style="width:100%; max-width: 320px; margin: 0 auto; border-radius:20px; overflow:hidden; border: 3px solid #e2e8f0; box-shadow: 0 10px 30px rgba(0,0,0,0.1);"></div>
                    <div class="mt-4 text-muted fw-bold">Scan QR Code Menu</div>
                    <button onclick="startScanner()" id="btn-start-scan" class="btn btn-primary rounded-pill px-5 py-2 mt-3 shadow-sm fw-bold"><i class="fas fa-camera me-2"></i> Mulai Scan</button>
                </div>
            </div>

            <div class="col-kanan" id="panel-cart">
                <div class="cart-header">
                    <span><i class="fas fa-receipt me-2 text-primary"></i> Current Order</span>
                    <div class="d-flex gap-2">
                        <button class="btn btn-sm btn-light text-danger bg-danger bg-opacity-10 fw-bold border-0 px-3 rounded-pill" onclick="resetCart()"><i class="fas fa-trash-alt me-1"></i> Clear</button>
                        <button class="btn btn-sm btn-light d-md-none border-0" onclick="toggleCart()"><i class="fas fa-chevron-down"></i></button>
                    </div>
                </div>
                
                <div class="cart-body" id="list-keranjang">
                    <div class="d-flex flex-column align-items-center justify-content-center h-100 opacity-25">
                        <i class="fas fa-shopping-basket fa-4x mb-3"></i>
                        <div class="fw-bold">Keranjang Kosong</div>
                    </div>
                </div>
                
                <div class="cart-footer">
                    <div class="mb-3">
                        <label class="small fw-bold text-muted mb-2 d-block">JENIS PESANAN</label>
                        <div class="d-flex gap-2">
                            <input type="radio" class="btn-check" name="jenis_pesanan" id="dine_in" value="dine_in" checked onchange="aturPager()">
                            <label class="btn btn-outline-primary flex-fill fw-bold" for="dine_in">
                                <i class="fas fa-utensils me-1"></i> DINE IN
                            </label>

                            <input type="radio" class="btn-check" name="jenis_pesanan" id="take_away" value="take_away" onchange="aturPager()">
                            <label class="btn btn-outline-warning flex-fill fw-bold" for="take_away">
                                <i class="fas fa-bag-shopping me-1"></i> TAKE AWAY
                            </label>
                        </div>
                    </div>

                    <div id="wrapper-pager" class="mb-3">
                        <div class="d-flex align-items-center justify-content-between mb-1">
                            <label class="small fw-bold text-muted mb-0">NOMOR PAGER</label>
                            <input type="number" id="nomor-pager" class="input-pager form-control" style="width: 80px; height: 35px;" value="0">
                        </div>
                         <small class="text-danger" id="error-pager" style="display:none; font-size:11px;">* Wajib diisi untuk Dine In</small>
                    </div>
                    
                    <div class="border-top border-dashed my-3"></div>

                    <div class="d-flex justify-content-between mb-1 align-items-end">
                        <span class="text-muted fw-bold small">Total Tagihan</span>
                        <span class="fw-bold fs-4 text-dark" id="label-total">Rp 0</span>
                    </div>
                    <div class="mt-3">
                        <button onclick="bukaModalBayar()" class="btn-bayar">
                            <i class="fas fa-wallet me-2"></i> PROSES BAYAR
                        </button>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <div class="mobile-cart-bar" onclick="toggleCart()">
        <div class="d-flex align-items-center gap-3">
            <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center fw-bold shadow-sm" style="width:32px; height:32px; font-size:12px;" id="mobile-qty">0</div>
            <div class="d-flex flex-column">
                <span style="font-size:10px; opacity:0.7; letter-spacing: 0.5px;">TOTAL BAYAR</span>
                <span class="fw-bold" style="font-size:16px;" id="mobile-total">Rp 0</span>
            </div>
        </div>
        <div class="fw-bold d-flex align-items-center" style="font-size:12px;">LIHAT <i class="fas fa-chevron-up ms-2 bg-white bg-opacity-20 rounded-circle p-1" style="width:20px;height:20px;display:flex;justify-content:center;align-items:center;"></i></div>
    </div>

    <div class="modal-overlay" id="modal-bayar">
        <div class="modal-pay">
            <div class="d-flex justify-content-between mb-4 align-items-center">
                <h5 class="fw-bold m-0"><i class="fas fa-cash-register me-2 text-primary"></i>Pembayaran</h5>
                <button onclick="tutupModal()" class="btn-close"></button>
            </div>
            
            <div class="modal-pay-body">
                <div class="text-center mb-4">
                    <small class="text-muted text-uppercase fw-bold" style="letter-spacing:1px; font-size:10px;">Total Yang Harus Dibayar</small>
                    <div class="fw-800 text-dark mt-1" style="font-size:32px; letter-spacing: -1px;" id="modal-total-display">Rp 0</div>
                </div>
                
                <div class="position-relative">
                    <span class="position-absolute start-0 top-50 translate-middle-y ms-3 fw-bold text-muted">Rp</span>
                    <input type="number" id="input-bayar" class="form-control text-center fw-bold border-2" style="font-size:20px; padding:15px; border-radius:12px;" onkeyup="hitungKembalian()" placeholder="0">
                </div>
                
                <div class="quick-cash-grid">
                    <button class="btn-cash" onclick="pilihUang('pas')">Uang Pas</button>
                    <button class="btn-cash" onclick="pilihUang(10000)">10k</button>
                    <button class="btn-cash" onclick="pilihUang(20000)">20k</button>
                    <button class="btn-cash" onclick="pilihUang(50000)">50k</button>
                    <button class="btn-cash" onclick="pilihUang(100000)">100k</button>
                    <button class="btn-cash text-danger border-danger bg-danger bg-opacity-10 fw-bold" onclick="document.getElementById('input-bayar').value=''; hitungKembalian()">CLR</button>
                </div>
                
                <div id="info-kembalian" class="display-kembali">Kembali: Rp 0</div>
                <button id="btn-final-bayar" onclick="submitTransaksi()" disabled class="btn btn-primary w-100 py-3 mt-4 fw-bold rounded-3 shadow-lg" style="font-size:16px;">
                    <i class="fas fa-print me-2"></i> SELESAI & CETAK
                </button>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modalSelesai" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content border-0 shadow-lg" style="border-radius:20px;">
                <div class="modal-header border-0 pb-0">
                    <h5 class="fw-bold ps-2"><i class="fas fa-bell text-warning me-2"></i>Pesanan Siap</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body p-4" id="isi-pesanan-siap">
                    <div class="text-center text-muted">Memuat data...</div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        const API_BASE = window.location.protocol + '//' + window.location.hostname + '/api_kasir/';
        let cart = [], menuData = [], html5QrcodeScanner = null, currentTempID = '';
        let shopInfo = { nama: "<?= $nama_toko; ?>", alamat: "-", footer: "Terima Kasih" };
        let isScanning = false; 

        initKasir();

        async function initKasir() {
            try {
                const resSet = await fetch(API_BASE + 'get_setting.php');
                const dataSet = await resSet.json();
                if(dataSet) shopInfo = { nama: dataSet.nama_toko, alamat: dataSet.alamat, footer: dataSet.footer_struk };
            } catch(e) {}

            fetch(API_BASE + 'get_menu.php').then(res => res.json()).then(data => { menuData = data; renderMenuGrid(data); });
            updateNotifSelesai();
            aturPager(); // Set tampilan awal
        }
        
        // --- LOGIKA DINE IN / TAKE AWAY ---
        function aturPager() {
            const isDineIn = document.getElementById('dine_in').checked;
            const wrapper = document.getElementById('wrapper-pager');
            const inputPager = document.getElementById('nomor-pager');
            
            if(isDineIn) {
                wrapper.style.display = 'block';
            } else {
                wrapper.style.display = 'none';
                inputPager.value = '0'; // Reset ke 0 kalau take away
            }
        }

        // --- MOBILE UI ---
        function toggleCart() {
            document.getElementById('panel-cart').classList.toggle('show');
            let overlay = document.getElementById('mobile-overlay');
            overlay.style.display = (overlay.style.display === 'block') ? 'none' : 'block';
        }

        // --- MENU & CART ---
        function renderMenuGrid(items) {
            const container = document.getElementById('daftar-menu-grid');
            container.innerHTML = '';
            if(items.length === 0) { container.innerHTML = '<div class="text-center mt-5 text-muted col-12">Menu tidak ditemukan.</div>'; return; }
            items.forEach(item => {
                let icon = 'utensils'; if(item.nama_kategori && item.nama_kategori.toLowerCase().includes('minum')) icon = 'coffee';
                const el = document.createElement('div'); el.className = 'menu-card';
                el.onclick = () => addToCart(item.id, item.nama_produk, item.harga);
                el.innerHTML = `
                    <div class="menu-icon-wrapper"><i class="fas fa-${icon}"></i></div>
                    <div class="menu-nama" title="${item.nama_produk}">${item.nama_produk}</div>
                    <div class="menu-harga">Rp ${parseInt(item.harga).toLocaleString()}</div>
                `;
                container.appendChild(el);
            });
        }

        function filterMenu() {
            const key = document.getElementById('cari-menu').value.toLowerCase();
            renderMenuGrid(menuData.filter(i => i.nama_produk.toLowerCase().includes(key)));
        }

        function addToCart(id, nama, harga) {
            const exist = cart.find(x => x.id == id);
            if (exist) exist.qty++; else cart.push({ id: id, n: nama, h: parseInt(harga), qty: 1 });
            renderCart();
        }

        function updateQty(id, delta) {
            const item = cart.find(x => x.id == id);
            if (item) { item.qty += delta; if (item.qty <= 0) cart = cart.filter(x => x.id != id); }
            renderCart();
        }

        function renderCart() {
            const container = document.getElementById('list-keranjang');
            const total = cart.reduce((sum, i) => sum + (i.h * i.qty), 0);
            const totalQty = cart.reduce((sum, i) => sum + i.qty, 0);
            
            document.getElementById('label-total').innerText = 'Rp ' + total.toLocaleString();
            document.getElementById('mobile-total').innerText = 'Rp ' + total.toLocaleString();
            document.getElementById('mobile-qty').innerText = totalQty;

            const mobileBar = document.querySelector('.mobile-cart-bar');
            if(window.innerWidth <= 768) { mobileBar.style.display = (cart.length > 0) ? 'flex' : 'none'; }

            if (cart.length === 0) {
                container.innerHTML = `
                <div class="d-flex flex-column align-items-center justify-content-center h-100 opacity-25">
                    <i class="fas fa-shopping-basket fa-4x mb-3"></i>
                    <div class="fw-bold">Belum ada pesanan</div>
                </div>`;
                if(document.getElementById('panel-cart').classList.contains('show')) toggleCart();
                return;
            }

            let html = '';
            cart.forEach(item => {
                let sub = item.h * item.qty;
                html += `
                <div class="cart-item">
                    <div class="cart-item-info">
                        <div class="cart-item-name">${item.n}</div>
                        <div class="cart-item-price">@${item.h.toLocaleString()}</div>
                    </div>
                    <div class="cart-item-actions">
                        <button class="btn-qty" onclick="updateQty('${item.id}', -1)"><i class="fas fa-minus" style="font-size:10px;"></i></button>
                        <span class="qty-val">${item.qty}</span>
                        <button class="btn-qty" onclick="updateQty('${item.id}', 1)"><i class="fas fa-plus" style="font-size:10px;"></i></button>
                        <div class="subtotal-val">${sub.toLocaleString()}</div>
                    </div>
                </div>`;
            });
            container.innerHTML = html;
        }

        function resetCart() { if(confirm("Kosongkan keranjang?")){ cart = []; currentTempID = ''; renderCart(); } }

        // --- 1. MEMBUKA MODAL PEMBAYARAN ---
        async function bukaModalBayar(){
            // Cek Keranjang
            if(cart.length === 0) return alert("Keranjang masih kosong!");
            
            // Validasi Pager (Khusus Dine In)
            const isDineIn = document.getElementById('dine_in').checked;
            const pagerVal = document.getElementById('nomor-pager').value;
            const err = document.getElementById('error-pager');
            
            if(isDineIn && (pagerVal == "" || pagerVal == "0")){
                alert("⚠️ UNTUK DINE IN, NOMOR PAGER WAJIB DIISI!");
                document.getElementById('nomor-pager').focus();
                err.style.display = 'block';
                return; 
            } else {
                err.style.display = 'none';
            }

            // Cek Ketersediaan Pager ke Server
            if(isDineIn) {
                const btnUtama = document.querySelector('.cart-footer .btn-bayar');
                const textAsli = btnUtama.innerHTML;
                btnUtama.innerHTML = '<i class="fas fa-circle-notch fa-spin"></i> Cek Pager...';
                btnUtama.disabled = true;

                try {
                    const response = await fetch(API_BASE + 'cek_pager.php?pager=' + pagerVal);
                    const result = await response.json();
                    btnUtama.innerHTML = textAsli;
                    btnUtama.disabled = false;

                    if (result.status === 'terpakai') {
                        alert(result.pesan);
                        document.getElementById('nomor-pager').focus();
                        return; 
                    }
                } catch (error) {
                    alert("Gagal koneksi. Cek internet/server.");
                    btnUtama.innerHTML = textAsli;
                    btnUtama.disabled = false;
                    return;
                }
            }

            // Buka Modal & Reset Input
            if(document.getElementById('panel-cart').classList.contains('show')) toggleCart();
            
            const total = cart.reduce((sum, i) => sum + (i.h * i.qty), 0);
            document.getElementById('modal-total-display').innerText = "Rp " + total.toLocaleString('id-ID');
            
            // Reset Input Uang jadi Kosong
            document.getElementById('input-bayar').value = ""; 
            
            // Reset Tampilan Kembalian (Default Kurang)
            const info = document.getElementById('info-kembalian');
            info.innerText = "Kurang: Rp " + total.toLocaleString('id-ID');
            info.style.background = "#fef2f2"; 
            info.style.color = "#ef4444"; 
            
            document.getElementById('modal-bayar').style.display = 'flex';
            document.getElementById('btn-final-bayar').disabled = true;
            
            // Fokus otomatis ke input uang
            setTimeout(() => document.getElementById('input-bayar').focus(), 100);
        }

        // --- 2. FITUR AKUMULASI UANG ---
        function pilihUang(nom) {
            const inputField = document.getElementById('input-bayar');
            const totalTagihan = cart.reduce((sum, i) => sum + (i.h * i.qty), 0);
            
            if (nom === 'pas') {
                // Uang Pas = Langsung set ke total
                inputField.value = totalTagihan;
            } else {
                // Akumulasi: Nilai yang ada + Nominal tombol
                let nilaiSekarang = parseInt(inputField.value);
                if (isNaN(nilaiSekarang)) nilaiSekarang = 0;
                
                let hasil = nilaiSekarang + nom;
                inputField.value = hasil;
            }
            
            // Wajib panggil ini agar teks kembalian berubah
            hitungKembalian(); 
        }
        
        // --- 3. HITUNG KEMBALIAN REALTIME ---
        function hitungKembalian(){
            const totalTagihan = cart.reduce((sum, i) => sum + (i.h * i.qty), 0);
            const bayar = parseInt(document.getElementById('input-bayar').value);
            
            // Jika input kosong atau NaN, anggap 0
            const uangMasuk = isNaN(bayar) ? 0 : bayar;
            
            const kembalian = uangMasuk - totalTagihan;
            
            const info = document.getElementById('info-kembalian');
            const btn = document.getElementById('btn-final-bayar');
            
            if(kembalian < 0){ 
                // Uang Kurang
                info.innerText = "Kurang: Rp " + Math.abs(kembalian).toLocaleString('id-ID'); 
                info.style.background = "#fef2f2"; 
                info.style.color = "#ef4444"; 
                info.style.borderColor = "#fca5a5";
                btn.disabled = true; // Tombol mati
            } else { 
                // Uang Cukup / Kembali
                info.innerText = "Kembali: Rp " + kembalian.toLocaleString('id-ID'); 
                info.style.background = "#ecfdf5"; 
                info.style.color = "#059669"; 
                info.style.borderColor = "#6ee7b7";
                btn.disabled = false; // Tombol hidup
            }
        }

        function tutupModal(){ document.getElementById('modal-bayar').style.display = 'none'; }
        
        

        function submitTransaksi() {
            const tot = cart.reduce((sum, i) => sum + (i.h * i.qty), 0);
            const byr = parseInt(document.getElementById('input-bayar').value);
            const pg = document.getElementById('nomor-pager').value;
            // Ambil Jenis Pesanan
            const jenis = document.getElementById('dine_in').checked ? 'dine_in' : 'take_away';

            const data = { 
                items: cart, 
                total: tot, 
                bayar: byr, 
                kembali: byr - tot, 
                nomor_pager: pg, 
                temp_id: currentTempID,
                jenis_pesanan: jenis // Kirim data jenis pesanan
            };
            
            const btn = document.getElementById('btn-final-bayar');
            btn.innerHTML = '<i class="fas fa-circle-notch fa-spin me-2"></i> Memproses...';
            btn.disabled = true;

            fetch(API_BASE + 'simpan_transaksi.php', { method: 'POST', body: JSON.stringify(data) })
            .then(res => res.json()).then(h => {
                if (h.status === 'sukses') {
                    tutupModal(); cetakStruk(h.kode, data, pg); 
                    cart = []; currentTempID = ''; renderCart(); 
                    document.getElementById('nomor-pager').value = "0";
                    // Reset ke Dine In
                    document.getElementById('dine_in').checked = true;
                    aturPager();
                    
                    btn.innerHTML = '<i class="fas fa-print me-2"></i> SELESAI & CETAK';
                } else {
                    alert("Gagal: " + h.pesan);
                    btn.disabled = false;
                    btn.innerHTML = '<i class="fas fa-print me-2"></i> SELESAI & CETAK';
                }
            });
        }

       function cetakStruk(no, d, pg) {
            const tgl = new Date().toLocaleString('id-ID');
            const garis = "--------------------------------";
            let struk = "";
            
            struk += "[C]<b>" + shopInfo.nama + "</b>\n";
            struk += "[C]" + shopInfo.alamat + "\n\n";
            struk += "[L]No   : " + no + "\n";
            struk += "[L]Tgl  : " + tgl + "\n";
            
            // Info Jenis Pesanan di Struk
            let labelJenis = (d.jenis_pesanan == 'dine_in') ? "DINE IN" : "TAKE AWAY";
            struk += "[L]Tipe : " + labelJenis + "\n";
            
            if(d.jenis_pesanan == 'dine_in'){
                struk += "[L]Pager: " + pg + "\n";
            }
            
            struk += "[L]Kasir: <?= $_SESSION['username'] ?? 'Admin' ?>\n"; 
            struk += "[C]" + garis + "\n";

            d.items.forEach(i => {
                struk += "[L]" + i.n + "\n";
                let subtotal = parseInt(i.qty * i.h).toLocaleString('id-ID');
                struk += "[L]" + i.qty + " x " + parseInt(i.h).toLocaleString('id-ID') + "[R]" + subtotal + "\n";
            });

            struk += "[C]" + garis + "\n";
            struk += "[L]TOTAL[R]" + parseInt(d.total).toLocaleString('id-ID') + "\n";
            struk += "[L]Bayar[R]" + parseInt(d.bayar).toLocaleString('id-ID') + "\n";
            struk += "[L]Kembali[R]" + parseInt(d.kembali).toLocaleString('id-ID') + "\n";
            struk += "[C]" + garis + "\n";
            struk += "[C]" + shopInfo.footer + "\n\n\n"; 

            try {
                var textEncoded = encodeURIComponent(struk);
                var urlRawbt = "rawbt:" + textEncoded;
                window.location.href = urlRawbt;
            } catch (e) { alert("Gagal print: " + e.message); }
        }

        // --- PAGER NOTIFIKASI ---
        function updateNotifSelesai() {
            fetch(API_BASE + 'get_pesanan_siap.php').then(r => r.json()).then(data => {
                const validNotif = data.filter(item => item.nomor_pager !== "0" && item.nomor_pager !== 0);
                const b = document.getElementById('badge-selesai');
                b.style.display = (validNotif.length > 0) ? 'block' : 'none'; 
                b.innerText = validNotif.length;
                let h = ''; 
                validNotif.forEach(i => {
                    h += `<div onclick="stopPager(${i.id})" class="p-3 mb-2 bg-warning bg-opacity-10 border border-warning rounded-4 text-center shadow-sm position-relative overflow-hidden" style="cursor:pointer">
                        <div class="fw-bold text-danger small mb-1">PAGER BERBUNYI!</div>
                        <h1 class="m-0 display-3 fw-bold text-dark">${i.nomor_pager}</h1>
                        <small class="text-muted">Tap untuk mematikan</small>
                    </div>`;
                });
                document.getElementById('isi-pesanan-siap').innerHTML = h || '<div class="text-center text-muted py-5"><i class="fas fa-bell-slash fa-2x mb-3 text-light"></i><br>Tidak ada notifikasi pager.</div>';
            }).catch(e=>{});
        }
        function stopPager(id){ let f=new FormData(); f.append('id',id); fetch(API_BASE+'update_status.php',{method:'POST',body:f}).then(r=>r.json()).then(()=>{updateNotifSelesai()}); }
        setInterval(updateNotifSelesai, 4000);

        // --- TABS & SCANNER ---
        function switchTab(m) {
            document.querySelectorAll('.tab-content').forEach(e => e.style.display = 'none');
            document.querySelectorAll('.btn-tab').forEach(e => e.classList.remove('active'));
            document.getElementById('view-' + m).style.display = 'block';
            document.getElementById('tab-btn-' + m).classList.add('active');
            if(m==='manual' && html5QrcodeScanner) { html5QrcodeScanner.clear().catch(e => {}); }
        }
        
        function startScanner() {
            document.getElementById('reader').style.display='block'; 
            document.getElementById('btn-start-scan').style.display='none';
            isScanning = false;
            if(html5QrcodeScanner === null) { html5QrcodeScanner = new Html5Qrcode("reader"); }
            html5QrcodeScanner.start(
                { facingMode: "environment" }, 
                { fps: 10, qrbox: { width: 250, height: 250 } }, 
                (decodedText) => {
                    if(isScanning) return; 
                    isScanning = true; 
                    html5QrcodeScanner.stop().then(() => {
                        let scanSukses = false;
                        try { 
                            let d = JSON.parse(decodedText); 
                            if(d.items){ 
                                currentTempID = d.temp_id; 
                                d.items.forEach(i => addToCart(i.id, i.n, i.h)); 
                                scanSukses = true;
                            } else { alert("Format QR Code Salah"); }
                        } catch(e){ alert("QR Code Tidak Dikenali / Rusak"); }

                        if(scanSukses){ alert("Scan Berhasil!"); switchTab('manual'); } 
                        else { switchTab('manual'); }
                    }).catch(err => { console.log(err); switchTab('manual'); });
                },
                (errorMessage) => {}
            ).catch(err => {
                alert("GAGAL BUKA KAMERA: " + err);
                document.getElementById('reader').style.display='none'; 
                document.getElementById('btn-start-scan').style.display='inline-block';
            });
        }
    </script>
</body>
</html>