<?php
session_start();
// Cek Login
if(!isset($_SESSION['status']) || $_SESSION['status'] != "sudah_login"){ 
    header("location:login.php"); 
    exit(); 
}
include 'sidebar.php';
?>

<style>
    :root {
        --primary-gradient: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
        --success-gradient: linear-gradient(135deg, #10b981 0%, #059669 100%);
    }

    .stat-card {
        border: none; border-radius: 16px; 
        transition: transform 0.2s, box-shadow 0.2s; 
        position: relative; overflow: hidden;
    }
    .stat-card:hover { transform: translateY(-5px); box-shadow: 0 10px 20px rgba(0,0,0,0.1) !important; }
    
    .bg-gradient-primary { background: var(--primary-gradient); color: white; }
    .bg-gradient-success { background: var(--success-gradient); color: white; }
    
    .icon-overlay {
        position: absolute; right: -10px; bottom: -15px;
        font-size: 6rem; opacity: 0.1; transform: rotate(-15deg);
        pointer-events: none;
    }
    
    .table thead th { 
        font-size: 0.7rem; text-transform: uppercase; letter-spacing: 0.8px; font-weight: 700;
        color: #64748b; background: #f8fafc; border-bottom: 1px solid #e2e8f0; padding-top: 15px; padding-bottom: 15px;
    }
    
    .filter-input {
        border: 1px solid #e2e8f0; border-radius: 8px; font-size: 0.9rem;
        padding: 8px 12px; background: #fff; color: #334155;
    }
    .filter-input:focus { border-color: #3b82f6; outline: none; box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1); }
</style>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h4 class="fw-bold text-dark mb-1">📊 Laporan Penjualan</h4>
        <span class="text-muted small">Pantau performa bisnis dan unduh rekap data.</span>
    </div>
</div>

<div class="row mb-4 g-3">
    <div class="col-md-6">
        <div class="card stat-card bg-gradient-primary p-4 h-100 shadow-sm">
            <div class="position-relative z-1">
                <small class="text-white-50 fw-bold text-uppercase ls-1" style="font-size: 0.7rem;">TOTAL OMZET (PERIODE INI)</small>
                <h2 class="fw-bold mb-0 mt-2" id="txt-omzet">Rp 0</h2>
                <div class="mt-3 small text-white-50 d-flex align-items-center gap-2">
                    <span class="badge bg-white bg-opacity-25 rounded-pill px-2">Lunas</span>
                    <span>Transaksi Berhasil</span>
                </div>
            </div>
            <i class="fas fa-wallet icon-overlay"></i>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card stat-card bg-gradient-success p-4 h-100 shadow-sm">
            <div class="position-relative z-1">
                <small class="text-white-50 fw-bold text-uppercase ls-1" style="font-size: 0.7rem;">TOTAL TRANSAKSI</small>
                <h2 class="fw-bold mb-0 mt-2" id="txt-transaksi">0</h2>
                <div class="mt-3 small text-white-50 d-flex align-items-center gap-2">
                    <span class="badge bg-white bg-opacity-25 rounded-pill px-2">Bon</span>
                    <span>Struk Tercetak</span>
                </div>
            </div>
            <i class="fas fa-receipt icon-overlay"></i>
        </div>
    </div>
</div>

<div class="card border-0 shadow-sm" style="border-radius: 12px; overflow: hidden;">
    
    <div class="card-header bg-white py-3 border-bottom d-flex flex-wrap justify-content-between align-items-center gap-3">
        <h6 class="fw-bold text-dark mb-0"><i class="fas fa-list-alt me-2 text-primary"></i> Riwayat Transaksi</h6>
        
        <div class="d-flex gap-2 flex-wrap align-items-center">
            <div class="d-flex align-items-center bg-light rounded px-2 border">
                <i class="fas fa-calendar text-muted small me-2"></i>
                <input type="date" id="tgl_mulai" class="filter-input border-0 bg-transparent p-1" value="<?php echo date('Y-m-01'); ?>">
                <span class="text-muted mx-2 small">s/d</span>
                <input type="date" id="tgl_selesai" class="filter-input border-0 bg-transparent p-1" value="<?php echo date('Y-m-d'); ?>">
            </div>

            <button onclick="loadLaporan()" class="btn btn-primary btn-sm fw-bold px-3 shadow-sm" style="border-radius: 8px;">
                <i class="fas fa-filter me-1"></i> Tampilkan
            </button>
            <button onclick="downloadExcel()" class="btn btn-success btn-sm fw-bold px-3 shadow-sm" style="border-radius: 8px;">
                <i class="fas fa-file-excel me-1"></i> Export
            </button>
        </div>
    </div>

    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead>
                    <tr>
                        <th class="ps-4">WAKTU</th>
                        <th>NO. BON</th>
                        <th class="text-center">PAGER</th>
                        <th>DETAIL ITEM</th>
                        <th class="text-end">TOTAL</th>
                        <th class="text-center pe-4">STATUS</th>
                    </tr>
                </thead>
                <tbody id="tabel-laporan">
                    <tr><td colspan="6" class="text-center py-5 text-muted">Silakan klik tombol Tampilkan...</td></tr>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>

<script>
    const API_URL = window.location.protocol + '//' + window.location.hostname + '/api_kasir/';

    function loadLaporan() {
        let m = document.getElementById('tgl_mulai').value;
        let s = document.getElementById('tgl_selesai').value;
        let tbody = document.getElementById('tabel-laporan');

        tbody.innerHTML = '<tr><td colspan="6" class="text-center py-5 text-muted"><i class="fas fa-circle-notch fa-spin me-2 text-primary"></i> Memuat data...</td></tr>';

        fetch(API_URL + `get_laporan_detail.php?start=${m}&end=${s}`)
        .then(res => res.json())
        .then(data => {
            // Update Ringkasan
            document.getElementById('txt-omzet').innerText = "Rp " + parseInt(data.summary.total_omzet || 0).toLocaleString('id-ID');
            document.getElementById('txt-transaksi').innerText = data.summary.jumlah_transaksi || 0;

            // Update Tabel
            if(!data.transaksi || data.transaksi.length === 0) {
                tbody.innerHTML = '<tr><td colspan="6" class="text-center py-5 text-muted opacity-50"><i class="fas fa-inbox fa-3x mb-3"></i><br>Tidak ada transaksi pada periode ini.</td></tr>';
                return;
            }

            let html = '';
            data.transaksi.forEach(trx => {
                let badge = trx.status === 'paid' 
                    ? '<span class="badge rounded-pill bg-success bg-opacity-10 text-success border border-success border-opacity-25 px-3 py-2">Lunas</span>' 
                    : '<span class="badge rounded-pill bg-warning bg-opacity-10 text-warning border border-warning border-opacity-25 px-3 py-2">Proses</span>';
                
                let tanggal = new Date(trx.tanggal_buat);
                let tglIndo = tanggal.toLocaleDateString('id-ID', { day: 'numeric', month: 'short' });
                let jamIndo = tanggal.toLocaleTimeString('id-ID', { hour: '2-digit', minute: '2-digit' });

                html += `
                <tr>
                    <td class="ps-4">
                        <div class="fw-bold text-dark" style="font-size: 0.9rem;">${tglIndo}</div>
                        <small class="text-muted" style="font-size: 0.75rem;">${jamIndo}</small>
                    </td>
                    <td>
                        <span class="font-monospace text-primary fw-bold" style="letter-spacing: 0.5px;">#${trx.kode_transaksi}</span>
                    </td>
                    <td class="text-center">
                        <span class="badge bg-light text-dark border shadow-sm" style="font-size: 0.85rem;">${trx.nomor_pager}</span>
                    </td>
                    <td>
                        <div class="text-muted small text-truncate" style="max-width: 250px; font-style: italic;" title="${trx.detail_items}">
                            ${trx.detail_items || '-'}
                        </div>
                    </td>
                    <td class="text-end fw-bold text-dark fs-6">Rp ${parseInt(trx.total_bayar).toLocaleString('id-ID')}</td>
                    <td class="text-center pe-4">${badge}</td>
                </tr>`;
            });
            tbody.innerHTML = html;
        })
        .catch(err => {
            console.error(err);
            tbody.innerHTML = '<tr><td colspan="6" class="text-center py-5 text-danger">Gagal memuat data. Cek koneksi internet.</td></tr>';
        });
    }

    function downloadExcel() {
        let m = document.getElementById('tgl_mulai').value;
        let s = document.getElementById('tgl_selesai').value;
        window.open(API_URL + `export_excel.php?start=${m}&end=${s}`, '_blank');
    }

    // Auto Load
    loadLaporan();
</script>