<?php
if (session_status() == PHP_SESSION_NONE) { session_start(); }
if(!isset($_SESSION['status'])){ header("location:login.php"); exit(); }

include 'koneksi.php';
include 'sidebar.php'; 

// SET TIMEZONE
date_default_timezone_set('Asia/Jakarta');

// LOGIKA FILTER TANGGAL
$tgl_awal  = isset($_GET['tgl_awal']) ? $_GET['tgl_awal'] : date('Y-m-01'); // Default awal bulan ini
$tgl_akhir = isset($_GET['tgl_akhir']) ? $_GET['tgl_akhir'] : date('Y-m-d'); // Default hari ini

// --- 1. HITUNG PENDAPATAN (OMZET) ---
$q_income = mysqli_query($koneksi, "
    SELECT SUM(total_bayar) as total 
    FROM transactions 
    WHERE status = 'paid' 
    AND DATE(tanggal_buat) BETWEEN '$tgl_awal' AND '$tgl_akhir'
");
$d_income = mysqli_fetch_assoc($q_income);
$total_pendapatan = $d_income['total'] ?? 0;

// --- 2. HITUNG PENGELUARAN (GROUP BY KATEGORI) ---
$q_expense = mysqli_query($koneksi, "
    SELECT kategori, SUM(nominal) as total 
    FROM expenses 
    WHERE DATE(tanggal) BETWEEN '$tgl_awal' AND '$tgl_akhir'
    GROUP BY kategori
");

$detail_beban = [];
$total_beban = 0;

while($row = mysqli_fetch_assoc($q_expense)){
    $detail_beban[] = $row;
    $total_beban += $row['total'];
}

// --- 3. HITUNG LABA BERSIH ---
$laba_bersih = $total_pendapatan - $total_beban;

// Tentukan warna kartu Laba
$bg_laba = ($laba_bersih >= 0) ? 'bg-success' : 'bg-danger';
$pesan_laba = ($laba_bersih >= 0) ? 'PROFIT (UNTUNG)' : 'LOSS (RUGI)';
?>

<h3 class="mb-4 fw-bold text-primary"><i class="fas fa-balance-scale me-2"></i> Laporan Laba Rugi</h3>

<div class="card border-0 shadow-sm mb-4">
    <div class="card-body py-3">
        <form method="GET" action="" class="d-flex gap-3 align-items-end">
            <div>
                <label class="small text-muted fw-bold">Dari Tanggal</label>
                <input type="date" name="tgl_awal" class="form-control" value="<?= $tgl_awal; ?>">
            </div>
            <div>
                <label class="small text-muted fw-bold">Sampai Tanggal</label>
                <input type="date" name="tgl_akhir" class="form-control" value="<?= $tgl_akhir; ?>">
            </div>
            <button type="submit" class="btn btn-primary"><i class="fas fa-filter me-2"></i> Tampilkan Laporan</button>
            <a href="laporan_laba_rugi.php" class="btn btn-outline-secondary">Reset</a>
        </form>
    </div>
</div>

<div class="row mb-4">
    <div class="col-md-4">
        <div class="card border-0 shadow-sm border-start border-5 border-primary h-100">
            <div class="card-body">
                <small class="text-muted text-uppercase fw-bold">Total Pendapatan</small>
                <h3 class="fw-bold text-primary mb-0">Rp <?= number_format($total_pendapatan, 0, ',', '.'); ?></h3>
                <small class="text-muted"><i class="fas fa-cash-register me-1"></i> Dari Transaksi Penjualan</small>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card border-0 shadow-sm border-start border-5 border-danger h-100">
            <div class="card-body">
                <small class="text-muted text-uppercase fw-bold">Total Beban</small>
                <h3 class="fw-bold text-danger mb-0">Rp <?= number_format($total_beban, 0, ',', '.'); ?></h3>
                <small class="text-muted"><i class="fas fa-file-invoice-dollar me-1"></i> Dari Menu Pengeluaran</small>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card <?= $bg_laba; ?> text-white border-0 shadow-sm h-100">
            <div class="card-body">
                <small class="text-white-50 text-uppercase fw-bold">Laba Bersih</small>
                <h3 class="fw-bold mb-0">Rp <?= number_format($laba_bersih, 0, ',', '.'); ?></h3>
                <small class="text-white-50"><?= $pesan_laba; ?></small>
            </div>
        </div>
    </div>
</div>

<div class="card border-0 shadow-sm mb-5">
    <div class="card-header bg-white py-3">
        <h6 class="fw-bold mb-0 text-dark">Rincian Laporan (<?= date('d M Y', strtotime($tgl_awal)); ?> s/d <?= date('d M Y', strtotime($tgl_akhir)); ?>)</h6>
    </div>
    <div class="card-body p-0">
        <table class="table table-hover align-middle mb-0">
            <thead class="bg-light">
                <tr>
                    <th class="ps-4">Keterangan</th>
                    <th class="text-end pe-4">Nominal</th>
                </tr>
            </thead>
            <tbody>
                <tr class="table-primary bg-opacity-10">
                    <td class="ps-4 fw-bold text-primary">PENDAPATAN USAHA</td>
                    <td></td>
                </tr>
                <tr>
                    <td class="ps-5">Penjualan (Omzet Kotor)</td>
                    <td class="text-end pe-4 fw-bold">Rp <?= number_format($total_pendapatan, 0, ',', '.'); ?></td>
                </tr>
                
                <tr class="table-danger bg-opacity-10">
                    <td class="ps-4 fw-bold text-danger">BEBAN & PENGELUARAN</td>
                    <td></td>
                </tr>
                
                <?php if(count($detail_beban) > 0) { 
                    foreach($detail_beban as $beban) { ?>
                    <tr>
                        <td class="ps-5"><?= $beban['kategori']; ?></td>
                        <td class="text-end pe-4 text-danger">(Rp <?= number_format($beban['total'], 0, ',', '.'); ?>)</td>
                    </tr>
                <?php } 
                } else { ?>
                    <tr><td colspan="2" class="ps-5 text-muted fst-italic">Tidak ada pengeluaran tercatat.</td></tr>
                <?php } ?>

                <tr class="fw-bold" style="background-color: #f8f9fa;">
                    <td class="ps-5">Total Beban</td>
                    <td class="text-end pe-4 text-danger">Rp <?= number_format($total_beban, 0, ',', '.'); ?></td>
                </tr>

                <tr class="<?= ($laba_bersih >= 0) ? 'table-success' : 'table-danger'; ?>">
                    <td class="ps-4 fw-bold fs-5 text-uppercase">LABA BERSIH</td>
                    <td class="text-end pe-4 fw-bold fs-5">Rp <?= number_format($laba_bersih, 0, ',', '.'); ?></td>
                </tr>
            </tbody>
        </table>
    </div>
</div>

<div class="text-center mb-5">
    <button onclick="window.print()" class="btn btn-secondary"><i class="fas fa-print me-2"></i> Cetak Laporan</button>
</div>

<?php include 'footer.php'; ?>