<?php
session_start();
include 'koneksi.php';

// Jika sudah login, lempar ke dashboard
if(isset($_SESSION['status']) && $_SESSION['status'] == "sudah_login"){
    header("location:dashboard.php");
    exit();
}

// Ambil Info Toko (Tetap pakai query biasa gpp karena tidak ada input user)
$nama_toko = "VEGAMEDI RESTO";
$logo_toko = "";
$q_set = mysqli_query($koneksi, "SELECT nama_toko, logo FROM settings LIMIT 1");
if($q_set && mysqli_num_rows($q_set) > 0){
    $d_set = mysqli_fetch_assoc($q_set);
    $nama_toko = $d_set['nama_toko'];
    $logo_toko = $d_set['logo'];
}

$error = "";

if(isset($_POST['login'])){
    $username = $_POST['username']; // Tidak perlu escape string lagi karena pakai prepare
    $password = $_POST['password'];

    // --- 1. KEAMANAN SQL INJECTION (PREPARED STATEMENT) ---
    // Gunakan ? sebagai placeholder
    $stmt = $koneksi->prepare("SELECT id, username, password, role, nama_lengkap FROM users WHERE username = ? AND is_active = 1");
    
    // Bind parameter (s = string)
    $stmt->bind_param("s", $username);
    
    // Eksekusi
    $stmt->execute();
    
    // Ambil hasil
    $result = $stmt->get_result();

    if($result->num_rows > 0){
        $data = $result->fetch_assoc();

        // --- 2. KEAMANAN PASSWORD (VERIFY) ---
        // Cek apakah password di database sudah di-hash atau masih polos?
        // (Logic ini untuk transisi dari sistem lama ke baru)
        
        $login_sukses = false;

        // Cek 1: Apakah cocok dengan password hash? (Standar Laravel/Modern)
        if(password_verify($password, $data['password'])){
            $login_sukses = true;
        } 
        // Cek 2: Apakah cocok dengan password polos? (Legacy/Lama)
        // Jika cocok, kita akan otomatis update jadi hash biar aman ke depannya
        elseif($password == $data['password']){
            $login_sukses = true;
            // Upgrade password jadi hash di database secara diam-diam
            $new_hash = password_hash($password, PASSWORD_DEFAULT);
            $uid = $data['id'];
            mysqli_query($koneksi, "UPDATE users SET password='$new_hash' WHERE id='$uid'");
        }

        if($login_sukses){
            // SET SESSION
            $_SESSION['username'] = $data['username'];
            $_SESSION['nama_lengkap'] = $data['nama_lengkap'];
            $_SESSION['role'] = $data['role'];
            $_SESSION['user_id'] = $data['id'];
            $_SESSION['status'] = "sudah_login";
            
            // Regenerate ID Session untuk mencegah Session Fixation
            session_regenerate_id(true);

            header("location:dashboard.php");
            exit();
        } else {
            $error = "Password salah!";
        }
    } else {
        $error = "Akun tidak ditemukan.";
    }
    
    $stmt->close();
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - <?= htmlspecialchars($nama_toko); ?></title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        /* ... copy css dari kode login sebelumnya ... */
        :root { --primary: #3b82f6; --primary-hover: #2563eb; }
        body { font-family: 'Inter', sans-serif; background-color: #fff; height: 100vh; overflow: hidden; }
        .login-container { height: 100vh; display: flex; }
        .login-image { flex: 1.5; background: url('https://images.unsplash.com/photo-1517248135467-4c7edcad34c4?q=80&w=2070&auto=format&fit=crop') no-repeat center center; background-size: cover; position: relative; display: flex; align-items: flex-end; padding: 50px; color: white; }
        .login-image::before { content: ""; position: absolute; top: 0; left: 0; right: 0; bottom: 0; background: linear-gradient(to bottom, rgba(0,0,0,0.1), rgba(0,0,0,0.8)); }
        .image-caption { position: relative; z-index: 2; animation: fadeUp 1s ease; }
        .login-form-wrapper { flex: 1; display: flex; align-items: center; justify-content: center; padding: 40px; background: #fff; position: relative; }
        .login-card { width: 100%; max-width: 400px; animation: fadeIn 0.8s ease; }
        .app-logo { width: 80px; height: 80px; object-fit: contain; border-radius: 50%; margin-bottom: 20px; background: #f8fafc; padding: 5px; border: 1px solid #e2e8f0; }
        .form-control { padding: 12px 15px; border-radius: 10px; border: 1px solid #cbd5e1; background-color: #f8fafc; font-size: 14px; }
        .form-control:focus { background-color: #fff; border-color: var(--primary); box-shadow: 0 0 0 4px rgba(59, 130, 246, 0.1); }
        .input-group-text { background: #f8fafc; border: 1px solid #cbd5e1; border-right: none; border-top-left-radius: 10px; border-bottom-left-radius: 10px; color: #64748b; }
        .input-group .form-control { border-left: none; }
        .btn-login { background: var(--primary); border: none; padding: 12px; border-radius: 10px; font-weight: 600; font-size: 16px; width: 100%; color: white; transition: 0.3s; box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3); }
        .btn-login:hover { background: var(--primary-hover); transform: translateY(-2px); box-shadow: 0 6px 15px rgba(59, 130, 246, 0.4); }
        @media (max-width: 768px) { .login-image { display: none; } .login-form-wrapper { flex: 1; background: #f8fafc; } .login-card { background: white; padding: 30px; border-radius: 20px; box-shadow: 0 4px 20px rgba(0,0,0,0.05); } }
        @keyframes fadeIn { from { opacity: 0; transform: translateY(20px); } to { opacity: 1; transform: translateY(0); } }
        @keyframes fadeUp { from { opacity: 0; transform: translateY(40px); } to { opacity: 1; transform: translateY(0); } }
    </style>
</head>
<body>

<div class="login-container">
    <div class="login-image">
        <div class="image-caption">
            <h1 class="fw-bold display-5">Kelola Restoran<br>Lebih Aman.</h1>
            <p class="lead opacity-75">Sistem terproteksi dengan enkripsi modern.</p>
        </div>
    </div>

    <div class="login-form-wrapper">
        <div class="login-card">
            <div class="text-center mb-4">
                <?php if(!empty($logo_toko) && file_exists("api_kasir/images/".$logo_toko)) { ?>
                    <img src="api_kasir/images/<?= $logo_toko; ?>" class="app-logo">
                <?php } elseif(!empty($logo_toko) && file_exists("images/".$logo_toko)) { ?>
                    <img src="images/<?= $logo_toko; ?>" class="app-logo">
                <?php } else { ?>
                    <div class="app-logo d-inline-flex align-items-center justify-content-center text-primary fs-2">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                <?php } ?>
                
                <h4 class="fw-bold text-dark mb-1">Login Aman</h4>
                <p class="text-muted small">Silakan masukkan kredensial Anda.</p>
            </div>

            <?php if($error){ ?>
                <div class="alert alert-danger py-2 small border-0 shadow-sm mb-4">
                    <i class="fas fa-exclamation-circle me-2"></i> <?= htmlspecialchars($error); ?>
                </div>
            <?php } ?>

            <form action="" method="POST">
                <div class="mb-3">
                    <label class="form-label small fw-bold text-secondary">USERNAME</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="fas fa-user"></i></span>
                        <input type="text" name="username" class="form-control" placeholder="Masukkan username" required autofocus>
                    </div>
                </div>

                <div class="mb-4">
                    <label class="form-label small fw-bold text-secondary">PASSWORD</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="fas fa-lock"></i></span>
                        <input type="password" name="password" class="form-control" placeholder="••••••••" required>
                    </div>
                </div>

                <button type="submit" name="login" class="btn-login">
                    LOGIN <i class="fas fa-lock ms-2"></i>
                </button>
            </form>

            <div class="text-center mt-4">
                <small class="text-muted">&copy; <?= date('Y'); ?> <?= htmlspecialchars($nama_toko); ?></small>
            </div>
        </div>
    </div>
</div>

</body>
</html>