<?php
if (session_status() == PHP_SESSION_NONE) { session_start(); }

// 1. PASTIKAN KONEKSI DATABASE ADA
if (!isset($koneksi)) { 
    if(file_exists('koneksi.php')) include 'koneksi.php';
}

$role = isset($_SESSION['role']) ? $_SESSION['role'] : '';
$page = basename($_SERVER['PHP_SELF']); 

// 2. AMBIL IDENTITAS TOKO DARI DB
$nama_sidebar = "VEGAMEDI APP"; // Default
$logo_sidebar = "";

if(isset($koneksi)){
    $q_side = mysqli_query($koneksi, "SELECT nama_toko, logo FROM settings LIMIT 1");
    if($q_side && mysqli_num_rows($q_side) > 0){
        $d_side = mysqli_fetch_assoc($q_side);
        $nama_sidebar = $d_side['nama_toko'];
        $logo_sidebar = $d_side['logo'];
    }
}

// LOGIKA SUBMENU AKTIF
$grup_master = ['admin_menu.php', 'admin_kategori.php', 'admin_bahan.php'];
$buka_master = in_array($page, $grup_master) ? 'show' : '';
$aktif_master = in_array($page, $grup_master) ? 'active' : '';

// --- UPDATE DI SINI: Tambahkan 'admin_setor.php' ke grup keuangan ---
$grup_keuangan = ['laporan.php', 'laporan_laba_rugi.php', 'admin_pengeluaran.php', 'admin_absensi.php', 'admin_gaji.php', 'admin_setor.php'];
$buka_keuangan = in_array($page, $grup_keuangan) ? 'show' : '';
$aktif_keuangan = in_array($page, $grup_keuangan) ? 'active' : '';
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $nama_sidebar; ?> - Dashboard</title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        :root {
            /* Warna Utama (Dark Navy) */
            --primary-color: #3b82f6; 
            --bg-body: #f3f4f6;        
            --sidebar-bg: #1e293b; 
            --sidebar-text: #e2e8f0; 
            --sidebar-muted: #94a3b8; 
            --sidebar-hover: #334155; 
            --sidebar-active-bg: rgba(59, 130, 246, 0.15);
            
            --sidebar-width: 260px; 
            --radius-card: 12px;
            --radius-btn: 6px;
        }

        body { 
            font-family: 'Inter', sans-serif; 
            background-color: var(--bg-body); 
            color: #334155;
            overflow-x: hidden; 
        }

        /* --- SIDEBAR CONFIG --- */
        #sidebar-wrapper {
            height: 100vh;
            width: var(--sidebar-width);
            background-color: var(--sidebar-bg);
            position: fixed; top: 0; left: 0; z-index: 9999; 
            transition: transform 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            transform: translateX(-100%); 
            overflow-y: auto; scrollbar-width: none; 
            box-shadow: 4px 0 15px rgba(0,0,0,0.1);
        }
        #sidebar-wrapper::-webkit-scrollbar { display: none; }

        /* HEADER */
        #sidebar-wrapper .sidebar-heading { 
            padding: 2.5rem 1.5rem 1.5rem; 
            display: flex;
            flex-direction: column;
            align-items: flex-start;
            gap: 12px;
            margin-bottom: 10px;
            border-bottom: 1px solid rgba(255,255,255,0.05);
        }

        .sidebar-logo {
            width: 50px; height: 50px; object-fit: cover;
            border-radius: 50%; border: 2px solid rgba(255,255,255,0.2);
        }
        .sidebar-brand-text {
            font-size: 1rem; font-weight: 600; color: #ffffff; 
            text-transform: uppercase; letter-spacing: 0.5px;
        }
        .sidebar-brand-sub { font-size: 0.75rem; color: var(--sidebar-muted); font-weight: 400; }

        /* --- MENU ITEM ANIMATION --- */
        .list-group-item {
            border: none; 
            padding: 12px 24px; 
            font-size: 0.9rem; 
            font-weight: 500;
            color: var(--sidebar-muted); 
            margin: 4px 0; /* Memberi jarak antar menu */
            border-radius: 0 25px 25px 0; /* Radius melengkung di kanan saja */
            background: transparent; 
            white-space: nowrap; 
            display: flex; align-items: center;
            border-left: 3px solid transparent; 
            
            /* ANIMASI TRANSISI UTAMA */
            transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
            position: relative;
            left: 0;
        }
        
        .list-group-item i { 
            width: 24px; text-align: left; margin-right: 12px; 
            font-size: 1rem; color: var(--sidebar-muted); opacity: 0.8;
            /* Animasi Ikon */
            transition: transform 0.3s ease;
        }

        /* --- EFEK HOVER (Saat Mouse Diarahkan) --- */
        .list-group-item:hover { 
            background-color: var(--sidebar-hover); 
            color: #ffffff; 
            padding-left: 30px; /* Geser teks sedikit ke kanan */
            border-left-color: rgba(255, 255, 255, 0.5); /* Garis samar putih */
        }
        
        .list-group-item:hover i { 
            color: #60a5fa; /* Ikon jadi biru muda */
            opacity: 1; 
            transform: scale(1.2); /* Ikon membesar sedikit */
        }

        /* --- ACTIVE STATE --- */
        .list-group-item.active { 
            background: linear-gradient(90deg, rgba(59, 130, 246, 0.2) 0%, rgba(59, 130, 246, 0) 100%);
            color: #60a5fa; 
            border-left-color: #60a5fa; 
            font-weight: 600;
        }
        .list-group-item.active i { color: #60a5fa; opacity: 1; }

        /* --- SUBMENU ANIMATION --- */
        .submenu-item { 
            font-size: 0.85rem; padding-left: 58px !important; 
            color: #64748b !important; 
            margin: 0 !important; border-radius: 0 !important;
            border-left: none !important;
        }
        .submenu-item:hover {
            color: #e2e8f0 !important;
            padding-left: 65px !important; /* Geser submenu sedikit saat hover */
            background: transparent !important;
        }
        .submenu-item.active { 
            color: #fff !important; font-weight: 600;
            background: transparent !important;
        }
        
        /* Dot indicator submenu */
        .submenu-item::before { 
            content: ""; display: inline-block; width: 5px; height: 5px; 
            border-radius: 50%; background-color: #64748b; margin-right: 10px; 
            vertical-align: middle; transition: all 0.3s ease;
        }
        .submenu-item:hover::before { background-color: #60a5fa; transform: scale(1.5); }
        .submenu-item.active::before { background-color: #60a5fa; box-shadow: 0 0 8px #60a5fa; }

        /* LABEL SECTIONS */
        .sidebar-section { 
            padding: 0 24px; font-size: 0.7rem; font-weight: 700; 
            color: #475569; text-transform: uppercase; 
            margin-top: 24px; margin-bottom: 8px; letter-spacing: 0.08em; 
        }

        /* NAVBAR & CONTENT */
        .navbar { background: #ffffff !important; border-bottom: 1px solid #e2e8f0; padding: 12px 24px; position: sticky; top: 0; z-index: 100; }
        .card { border: none; border-radius: var(--radius-card); background: #fff; box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.05); }

        /* RESPONSIVE */
        #sidebar-overlay { display: none; position: fixed; top: 0; left: 0; width: 100vw; height: 100vh; background: rgba(0, 0, 0, 0.5); z-index: 9998; backdrop-filter: blur(2px); cursor: pointer; }
        #page-content-wrapper { width: 100%; margin-left: 0; transition: margin .3s; min-height: 100vh; padding-top: 0; }
        @media (min-width: 768px) {
            #sidebar-wrapper { transform: translateX(0); }
            #page-content-wrapper { margin-left: var(--sidebar-width); }
            body.sb-sidenav-toggled #sidebar-wrapper { transform: translateX(-100%); }
            body.sb-sidenav-toggled #page-content-wrapper { margin-left: 0; }
            #sidebar-overlay { display: none !important; }
        }
        @media (max-width: 768px) {
            body.sb-sidenav-toggled #sidebar-wrapper { transform: translateX(0); }
            body.sb-sidenav-toggled #sidebar-overlay { display: block; }
        }
        .dropdown-toggle::after { margin-left: auto; filter: invert(1) opacity(0.5); transition: transform 0.3s; }
        .dropdown-toggle[aria-expanded="true"]::after { transform: rotate(180deg); } /* Panah berputar saat diklik */
    </style>
</head>
<body>

<div id="sidebar-overlay"></div>

<div class="d-flex" id="wrapper">
    
    <div id="sidebar-wrapper">
        
        <div class="sidebar-heading">
            <div class="d-flex align-items-center gap-3">
                <?php if(!empty($logo_sidebar) && file_exists("images/".$logo_sidebar)) { ?>
                    <img src="images/<?= $logo_sidebar; ?>" class="sidebar-logo" alt="Logo">
                <?php } else { ?>
                    <div class="sidebar-logo d-flex align-items-center justify-content-center" style="background: rgba(255,255,255,0.1); color: #fff;">
                        <i class="fas fa-store"></i>
                    </div>
                <?php } ?>
                <div>
                    <div class="sidebar-brand-text"><?= strtoupper($nama_sidebar); ?></div>
                    <div class="sidebar-brand-sub">Administrator</div>
                </div>
            </div>
        </div>

        <div class="list-group list-group-flush mt-2 mb-5">
            
            <div class="sidebar-section">Main Menu</div>
            
            <a href="dashboard.php" class="list-group-item list-group-item-action <?php echo ($page == 'dashboard.php') ? 'active' : ''; ?>">
                <i class="fas fa-home"></i> Dashboard
            </a>
            <a href="kasir.php" class="list-group-item list-group-item-action <?php echo ($page == 'kasir.php') ? 'active' : ''; ?>">
                <i class="fas fa-cash-register"></i> Mesin Kasir
            </a>
            <a href="dapur.php" class="list-group-item list-group-item-action <?php echo ($page == 'dapur.php') ? 'active' : ''; ?>">
                <i class="fas fa-fire-burner"></i> Monitor Dapur
            </a>

            <div class="sidebar-section">Master Data</div>

            <a href="#submenuMaster" data-bs-toggle="collapse" class="list-group-item list-group-item-action dropdown-toggle <?php echo $aktif_master; ?>">
                <i class="fas fa-box-open"></i> Produk & Stok
            </a>
            <div class="collapse <?php echo $buka_master; ?>" id="submenuMaster">
                <a href="admin_menu.php" class="list-group-item list-group-item-action submenu-item <?php echo ($page == 'admin_menu.php') ? 'active' : ''; ?>">Daftar Menu</a>
                <a href="admin_kategori.php" class="list-group-item list-group-item-action submenu-item <?php echo ($page == 'admin_kategori.php') ? 'active' : ''; ?>">Kategori</a>
                <a href="admin_bahan.php" class="list-group-item list-group-item-action submenu-item <?php echo ($page == 'admin_bahan.php') ? 'active' : ''; ?>">Bahan Baku</a>
            </div>

            <div class="sidebar-section">Keuangan</div>

            <a href="#submenuKeuangan" data-bs-toggle="collapse" class="list-group-item list-group-item-action dropdown-toggle <?php echo $aktif_keuangan; ?>">
                <i class="fas fa-chart-pie"></i> Laporan
            </a>
            <div class="collapse <?php echo $buka_keuangan; ?>" id="submenuKeuangan">
                <a href="admin_pengeluaran.php" class="list-group-item list-group-item-action submenu-item <?php echo ($page == 'admin_pengeluaran.php') ? 'active' : ''; ?>">Pengeluaran</a>
                <a href="admin_setor.php" class="list-group-item list-group-item-action submenu-item <?php echo ($page == 'admin_setor.php') ? 'active' : ''; ?>">Setor Bank</a>
                <a href="laporan.php" class="list-group-item list-group-item-action submenu-item <?php echo ($page == 'laporan.php') ? 'active' : ''; ?>">Penjualan</a>
                <a href="laporan_laba_rugi.php" class="list-group-item list-group-item-action submenu-item <?php echo ($page == 'laporan_laba_rugi.php') ? 'active' : ''; ?>">Laba Rugi</a>
                <?php if($role == 'admin'){ ?>
                <a href="admin_absensi.php" class="list-group-item list-group-item-action submenu-item <?php echo ($page == 'admin_absensi.php') ? 'active' : ''; ?>">Absensi</a>
                <a href="admin_gaji.php" class="list-group-item list-group-item-action submenu-item <?php echo ($page == 'admin_gaji.php') ? 'active' : ''; ?>">Gaji Karyawan</a>
                <?php } ?>
            </div>

            <?php if($role == 'admin'){ ?>
                <div class="sidebar-section">Settings</div>
                <a href="admin_setting.php" class="list-group-item list-group-item-action <?php echo ($page == 'admin_setting.php') ? 'active' : ''; ?>"><i class="fas fa-cog"></i> Pengaturan Toko</a>
                <a href="admin_users.php" class="list-group-item list-group-item-action <?php echo ($page == 'admin_users.php') ? 'active' : ''; ?>"><i class="fas fa-users"></i> Data Karyawan</a>
            <?php } ?>

            <a href="logout.php" class="list-group-item list-group-item-action text-danger mt-5 mb-5 fw-bold" style="opacity:0.8;">
                <i class="fas fa-sign-out-alt text-danger"></i> Logout
            </a>
            
        </div>
    </div>

    <div id="page-content-wrapper">
        <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm">
            <div class="container-fluid">
                <button class="btn btn-outline-secondary border-0" id="sidebarToggle">
                    <i class="fas fa-bars"></i>
                </button>
                
                <div class="ms-auto d-flex align-items-center gap-3">
                    <div class="text-end lh-1">
                        <div class="fw-bold small"><?php echo strtoupper($_SESSION['username']); ?></div>
                        <span class="badge bg-light text-secondary border"><?php echo isset($_SESSION['role']) ? ucfirst($_SESSION['role']) : 'Staff'; ?></span>
                    </div>
                    <div style="width: 40px; height: 40px; background: #3b82f6; color:white; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-weight: 600;">
                        <?php echo substr($_SESSION['username'], 0, 1); ?>
                    </div>
                </div>
            </div>
        </nav>

        <div class="container-fluid px-4 py-4">