<?php
include 'koneksi.php';
date_default_timezone_set('Asia/Jakarta'); 

$json = file_get_contents('php://input');
$data = json_decode($json, true);

if(isset($data['items']) && count($data['items']) > 0) {
    
    $total   = $data['total'];
    $bayar   = isset($data['bayar']) ? $data['bayar'] : $total;
    $kembali = isset($data['kembali']) ? $data['kembali'] : 0;
    $temp_id = isset($data['temp_id']) ? $data['temp_id'] : ''; 
    $kode    = "INV-" . date("YmdHis"); 

    // --- 1. AMBIL JENIS PESANAN ---
    $jenis_pesanan = isset($data['jenis_pesanan']) ? $data['jenis_pesanan'] : 'dine_in';

    // --- 2. TENTUKAN NOMOR PAGER ---
    $pager = 0;
    if($jenis_pesanan == 'take_away'){
        $pager = 0; // Take away selalu 0
    } else {
        // Dine In: Ambil dari input
        if(!empty($data['nomor_pager'])) $pager = $data['nomor_pager'];
    }

    // ==================================================================
    // 🛑 VALIDASI PAGER GANDA (FITUR BARU)
    // ==================================================================
    if ($pager > 0) {
        // Cek apakah pager ini sedang dipakai di transaksi yang BELUM 'selesai'
        // Kita cek status_pesanan != 'selesai'
        $cek_pager = mysqli_query($koneksi, "SELECT id FROM transactions 
                                             WHERE nomor_pager = '$pager' 
                                             AND status_pesanan != 'selesai'");
        
        if (mysqli_num_rows($cek_pager) > 0) {
            // JIKA KETEMU => STOP PROSES!
            echo json_encode([
                "status" => "gagal", 
                "pesan" => "⛔ PAGER #$pager SEDANG DIPAKAI!\n\nPager ini belum dikembalikan/diselesaikan dari transaksi sebelumnya. Harap gunakan nomor lain."
            ]);
            exit(); // Matikan script, jangan simpan ke database
        }
    }
    // ==================================================================

    $metode_bayar = isset($data['payment_method']) ? $data['payment_method'] : 'cash';
    $tanggal_indo = date("Y-m-d H:i:s");

    // --- 3. SIMPAN DATA (Jika lolos validasi di atas) ---
    $sql_transaksi = "INSERT INTO transactions 
        (kode_transaksi, temp_id, jenis_pesanan, total_bayar, bayar, kembali, metode_bayar, nomor_pager, status, tanggal_buat, status_dapur, status_pesanan) 
        VALUES 
        ('$kode', '$temp_id', '$jenis_pesanan', '$total', '$bayar', '$kembali', '$metode_bayar', '$pager', 'paid', '$tanggal_indo', 'pending', 'proses')";
    
    if(mysqli_query($koneksi, $sql_transaksi)){
        $transaksi_id = mysqli_insert_id($koneksi); 
        
        foreach($data['items'] as $item){
            $prod_id = $item['id'];
            
            $nama  = isset($item['n']) ? $item['n'] : (isset($item['name']) ? $item['name'] : $item['nama']);
            $harga = isset($item['h']) ? $item['h'] : (isset($item['price']) ? $item['price'] : $item['harga']);
            $qty   = isset($item['q']) ? $item['q'] : $item['qty'];
            
            $sub = $harga * $qty;
            
            $q_item = "INSERT INTO transaction_items (transaction_id, product_id, nama_produk_snapshot, harga_saat_itu, qty, subtotal) VALUES ('$transaksi_id', '$prod_id', '$nama', '$harga', '$qty', '$sub')";
            mysqli_query($koneksi, $q_item);
            
            // Update Stok
            mysqli_query($koneksi, "UPDATE products SET stok = stok - $qty WHERE id = '$prod_id'");

            // Update Resep
            $q_resep = mysqli_query($koneksi, "SELECT * FROM product_recipes WHERE product_id = '$prod_id'");
            if($q_resep){
                while($resep = mysqli_fetch_assoc($q_resep)){
                    $id_bahan = $resep['material_id'];
                    $jml_pakai = $resep['jumlah_pakai'];
                    $total_bahan = $jml_pakai * $qty;
                    mysqli_query($koneksi, "UPDATE raw_materials SET stok = stok - $total_bahan WHERE id = '$id_bahan'");
                }
            }
        }
        
        echo json_encode(["status" => "sukses", "id_transaksi" => $transaksi_id, "kode" => $kode]);
    } else {
        echo json_encode(["status" => "gagal", "pesan" => mysqli_error($koneksi)]);
    }
} else {
    echo json_encode(["status" => "kosong", "pesan" => "Keranjang kosong"]);
}
?>