<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *"); 

// CEK KONEKSI (Prioritaskan file di folder yang sama)
if(file_exists('koneksi.php')) {
    include 'koneksi.php';
} elseif(file_exists('../koneksi.php')) {
    include '../koneksi.php';
} else {
    echo json_encode(["status" => "error", "pesan" => "File koneksi.php tidak ditemukan!"]);
    exit();
}

// ==========================================
// 1. LOGIKA PENANGKAPAN ID (UNIVERSAL)
// ==========================================
$id = null;

if (isset($_POST['id']) && !empty($_POST['id'])) {
    $id = $_POST['id'];
} else {
    $json = file_get_contents('php://input');
    $data_json = json_decode($json, true);
    if (isset($data_json['id'])) {
        $id = $data_json['id'];
    } elseif (isset($_GET['id'])) {
        $id = $_GET['id'];
    }
}

// ==========================================
// 2. PROSES UPDATE DATABASE
// ==========================================
if($id){
    // Ambil Data Pager
    $cek_query = mysqli_query($koneksi, "SELECT nomor_pager FROM transactions WHERE id='$id'");
    
    if(mysqli_num_rows($cek_query) > 0){
        $row = mysqli_fetch_assoc($cek_query);
        
        // --- PERBAIKAN UTAMA DI SINI ---
        // Jika Pager 0 (Bungkus) -> status 'selesai' (Database Anda kenalnya 'selesai', bukan 'completed')
        // Jika Pager > 0 -> status 'siap' (Bunyi)
        
        if($row['nomor_pager'] == '0' || $row['nomor_pager'] == 0){
            $status_pesanan = 'selesai'; // JANGAN PAKAI 'completed'
        } else {
            $status_pesanan = 'siap';
        }

        // UPDATE STATUS
        $sql = "UPDATE transactions SET 
                status_dapur = 'ready', 
                status_pesanan = '$status_pesanan' 
                WHERE id = '$id'";

        if(mysqli_query($koneksi, $sql)){
            echo json_encode(["status" => "sukses", "id_received" => $id]);
        } else {
            // Tampilkan error database asli untuk debugging
            echo json_encode(["status" => "error", "pesan" => "Database Error: " . mysqli_error($koneksi)]);
        }
    } else {
        echo json_encode(["status" => "error", "pesan" => "Transaksi tidak ditemukan"]);
    }
} else {
    echo json_encode(["status" => "error", "pesan" => "ID Kosong"]);
}
?>